<?php
/**
 * Auto-Configure Email Settings for Gmail
 * Using Port 465 (SSL) - which is working
 */

require_once 'config/config.php';
require_once 'classes/Database.php';

$db = Database::getInstance();

// Email credentials
$email = 's26118152@gmail.com';
$password = 'gyiv ebml hzoc otmh';  // App password
$from_email = 's26118152@gmail.com';
$from_name = 'Advanced Mobile Info';

echo "=== Auto-Configuring Email Settings ===\n\n";

// Configuration to save
$settings = [
    'email_mode' => 'smtp',
    'mail_host' => 'smtp.gmail.com',
    'mail_port' => '465',           // Using SSL port instead of TLS
    'mail_encryption' => 'ssl',      // Using SSL instead of TLS
    'mail_username' => $email,
    'mail_from_email' => $from_email,
    'mail_from_name' => $from_name
];

echo "Saving settings to database...\n\n";

try {
    // Save each setting
    foreach ($settings as $key => $value) {
        // Check if setting exists
        $exists = $db->fetch(
            'SELECT id FROM admin_settings WHERE setting_key = ?',
            [$key]
        );
        
        if ($exists) {
            // Update existing
            $db->update(
                'admin_settings',
                ['setting_value' => $value],
                'setting_key = ?',
                [$key]
            );
            echo "✅ Updated: $key = $value\n";
        } else {
            // Insert new
            $db->insert(
                'admin_settings',
                [
                    'setting_key' => $key,
                    'setting_value' => $value,
                    'created_at' => date('Y-m-d H:i:s')
                ]
            );
            echo "✅ Created: $key = $value\n";
        }
    }
    
    // Save encrypted password
    $encrypted_password = base64_encode($password);
    $exists = $db->fetch(
        'SELECT id FROM admin_settings WHERE setting_key = ?',
        ['mail_password_encrypted']
    );
    
    if ($exists) {
        $db->update(
            'admin_settings',
            ['setting_value' => $encrypted_password],
            'setting_key = ?',
            ['mail_password_encrypted']
        );
        echo "✅ Updated: mail_password_encrypted\n";
    } else {
        $db->insert(
            'admin_settings',
            [
                'setting_key' => 'mail_password_encrypted',
                'setting_value' => $encrypted_password,
                'created_at' => date('Y-m-d H:i:s')
            ]
        );
        echo "✅ Created: mail_password_encrypted\n";
    }
    
    echo "\n✅ Email configuration saved successfully!\n\n";
    
    // Display saved settings
    echo "=== Saved Configuration ===\n";
    echo "Email Mode:       " . $settings['email_mode'] . "\n";
    echo "SMTP Host:        " . $settings['mail_host'] . "\n";
    echo "SMTP Port:        " . $settings['mail_port'] . " (SSL)\n";
    echo "Encryption:       " . $settings['mail_encryption'] . "\n";
    echo "Username:         " . $settings['mail_username'] . "\n";
    echo "From Email:       " . $settings['mail_from_email'] . "\n";
    echo "From Name:        " . $settings['mail_from_name'] . "\n";
    echo "Password:         " . str_repeat('*', strlen($password)) . " (encrypted)\n";
    
    echo "\n✅ Ready to send emails!\n";
    echo "\nYou can now:\n";
    echo "1. Test with 'Send Test Email' in Admin Dashboard\n";
    echo "2. OTP emails will be sent automatically during registration\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}

?>
