<?php
require_once 'config/config.php';
require_once 'classes/Database.php';

$db = Database::getInstance();

try {
    // Add device tracking columns to users table
    $db->query("ALTER TABLE users ADD COLUMN IF NOT EXISTS last_device_type VARCHAR(50) DEFAULT 'Unknown'");
    $db->query("ALTER TABLE users ADD COLUMN IF NOT EXISTS last_device_ip VARCHAR(45) DEFAULT NULL");
    $db->query("ALTER TABLE users ADD COLUMN IF NOT EXISTS last_login_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP");
    
    echo "✅ Device tracking columns added successfully!<br>";
    echo "Columns added:<br>";
    echo "• last_device_type<br>";
    echo "• last_device_ip<br>";
    echo "• last_login_at<br>";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage();
}
?>
