<?php
require_once 'config/database.php';

$db = Database::getInstance();

try {
    echo "🔄 Adding custom_code column to users table...\n";
    
    // Check if column exists
    $checkColumn = $db->fetch("SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS 
                               WHERE TABLE_NAME = 'users' AND COLUMN_NAME = 'custom_code'");
    
    if (!$checkColumn) {
        // Add column
        $db->query("ALTER TABLE users ADD COLUMN custom_code VARCHAR(50) UNIQUE DEFAULT NULL AFTER id");
        echo "✅ Column added successfully!\n";
    } else {
        echo "⚠️ Column already exists!\n";
    }
    
    // Get all users
    $users = $db->fetchAll("SELECT id FROM users ORDER BY id ASC");
    
    echo "\n📋 Updating users with custom codes:\n";
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    
    foreach ($users as $user) {
        $id = $user['id'];
        $custom_code = 'SSRT00' . str_pad($id, 4, '0', STR_PAD_LEFT);
        
        $db->update('users', ['custom_code' => $custom_code], 'id = :id', [':id' => $id]);
        
        echo "ID: {$id} → {$custom_code}\n";
    }
    
    echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
    echo "✅ All users updated successfully!\n\n";
    
    // Display final result
    echo "📊 Final Result:\n";
    $result = $db->fetchAll("SELECT id, email, custom_code FROM users");
    
    foreach ($result as $row) {
        echo "  ID: {$row['id']} | Email: {$row['email']} | Code: {$row['custom_code']}\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
?>
