<?php
require_once __DIR__ . '/config/database.php';

$db = Database::getInstance();

// Check if admin_chats table exists, if not create it
$checkTable = $db->fetch("SELECT 1 FROM information_schema.tables WHERE table_name = 'admin_chats'");

if (!$checkTable) {
    // Create admin_chats table
    $db->query("
        CREATE TABLE admin_chats (
            id INT PRIMARY KEY AUTO_INCREMENT,
            user_id INT NOT NULL,
            admin_id INT DEFAULT NULL,
            message TEXT NOT NULL,
            sender_type ENUM('user', 'admin') NOT NULL DEFAULT 'user',
            is_read TINYINT(1) DEFAULT 0,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
            FOREIGN KEY (admin_id) REFERENCES users(id) ON DELETE SET NULL,
            INDEX (user_id, created_at),
            INDEX (admin_id)
        )
    ");
    echo "✅ admin_chats table created successfully\n";
} else {
    echo "⚠️ admin_chats table already exists\n";
}

echo "✅ Setup complete!\n";
?>
