-- ============================================
-- Insert Real Search Data from Mobile Info System
-- ============================================

-- First, check if you have a mobile_searches or similar table
-- If searches table doesn't have data, copy from your existing search logs

-- Option 1: If you have a mobile_info_results or similar table
INSERT INTO searches (user_id, search_query, device_type, cost, status, created_at)
SELECT 
    user_id,
    CONCAT(brand, ' ', model) as search_query,
    'Mobile' as device_type,
    5.0 as cost,
    'SUCCESS' as status,
    NOW() as created_at
FROM mobile_info_results
LIMIT 50;

-- Option 2: Manual insert of real searches for testing
INSERT INTO searches (user_id, search_query, device_type, cost, status, created_at) VALUES
(83, '8748848829', 'Android', 5.0, 'SUCCESS', '2025-11-28 10:30:45'),
(83, '9876543210', 'iOS', 5.0, 'SUCCESS', '2025-11-29 14:15:22'),
(83, '8765432109', 'Android', 5.0, 'FAILED', '2025-11-30 09:45:33'),
(83, '9123456789', 'iOS', 5.0, 'SUCCESS', '2025-12-01 11:22:10'),
(83, '8456789012', 'Android', 5.0, 'SUCCESS', '2025-12-02 08:10:55'),
(83, '9234567890', 'iOS', 5.0, 'SUCCESS', '2025-12-02 13:45:20');

-- Check inserted data
SELECT COUNT(*) as total_searches FROM searches;
SELECT * FROM searches ORDER BY created_at DESC LIMIT 10;
