<?php
/**
 * SIMPLE PENDING PAYMENTS ADMIN PAGE
 */
require_once(__DIR__ . '/../../config/config.php');
require_once(__DIR__ . '/../../classes/Database.php');
require_once(__DIR__ . '/../../classes/Payment.php');

$db = Database::getInstance();
$payment = new Payment();
$pendingPayments = $payment->getPendingApprovals(20);

$message = '';
$error = '';

// Handle approve
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    $orderId = $_POST['order_id'] ?? '';
    $action = $_POST['action'];
    
    if ($action === 'approve') {
        $order = $db->fetch('SELECT * FROM payment_orders WHERE order_id = ?', [$orderId]);
        if ($order && $order['status'] === 'awaiting_approval') {
            $result = $payment->confirmPayment($orderId, $order['transaction_id'], 'manual_approval');
            if ($result['status']) {
                $message = '✅ Payment approved! Credits added to user account.';
                $pendingPayments = $payment->getPendingApprovals(20);
            } else {
                $error = '❌ ' . $result['message'];
            }
        }
    } elseif ($action === 'reject') {
        $order = $db->fetch('SELECT * FROM payment_orders WHERE order_id = ?', [$orderId]);
        if ($order && $order['status'] === 'awaiting_approval') {
            $db->update('payment_orders', ['status' => 'rejected'], 'order_id = :order_id', ['order_id' => $orderId]);
            $message = '✅ Payment rejected.';
            $pendingPayments = $payment->getPendingApprovals(20);
        }
    }
}
?>

<style>
    body { font-family: Arial, sans-serif; padding: 20px; background: #f5f5f5; }
    .container { max-width: 1000px; margin: 0 auto; }
    .header { margin-bottom: 30px; }
    .header h2 { color: #333; }
    .badge { background: red; color: white; padding: 5px 12px; border-radius: 20px; font-weight: bold; }
    .alert { padding: 15px; margin-bottom: 20px; border-radius: 5px; }
    .alert-success { background: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
    .alert-danger { background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
    .payment-item {
        background: white;
        padding: 20px;
        margin-bottom: 15px;
        border-left: 5px solid #007bff;
        border-radius: 5px;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    .payment-item.green { border-left-color: #28a745; }
    .payment-info { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin: 15px 0; }
    .info-row { padding: 8px 0; }
    .info-label { font-weight: bold; color: #666; font-size: 12px; }
    .info-value { color: #333; font-weight: bold; font-size: 14px; margin-top: 3px; }
    .buttons { display: grid; grid-template-columns: 1fr 1fr; gap: 10px; margin-top: 15px; }
    button { padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; font-weight: bold; font-size: 14px; }
    .btn-approve { background: #28a745; color: white; }
    .btn-approve:hover { background: #218838; }
    .btn-reject { background: #dc3545; color: white; }
    .btn-reject:hover { background: #c82333; }
    .btn-view { background: #007bff; color: white; padding: 8px 15px; font-size: 12px; }
    .btn-view:hover { background: #0056b3; }
    .empty { text-align: center; padding: 40px; color: #999; font-size: 16px; }
    .screenshot-link { color: #007bff; text-decoration: none; }
    .screenshot-link:hover { text-decoration: underline; }
</style>

<div class="container">
    <div class="header">
        <h2>
            ⏳ Pending Payments 
            <?php if (count($pendingPayments) > 0): ?>
                <span class="badge"><?php echo count($pendingPayments); ?></span>
            <?php endif; ?>
        </h2>
    </div>

    <?php if ($message): ?>
        <div class="alert alert-success"><?php echo $message; ?></div>
    <?php endif; ?>

    <?php if ($error): ?>
        <div class="alert alert-danger"><?php echo $error; ?></div>
    <?php endif; ?>

    <?php if (count($pendingPayments) > 0): ?>
        <?php foreach ($pendingPayments as $payment): ?>
            <div class="payment-item">
                <div style="display: flex; justify-content: space-between; align-items: center;">
                    <div>
                        <h3 style="margin: 0 0 5px 0;"><?php echo htmlspecialchars($payment['name']); ?></h3>
                        <p style="margin: 0; color: #666; font-size: 13px;">📧 <?php echo htmlspecialchars($payment['email']); ?></p>
                    </div>
                    <div style="text-align: right;">
                        <div style="font-size: 24px; font-weight: bold; color: #28a745;">₹<?php echo number_format($payment['amount'], 2); ?></div>
                        <div style="font-size: 12px; color: #999;">Amount</div>
                    </div>
                </div>

                <div class="payment-info">
                    <div>
                        <div class="info-row">
                            <div class="info-label">Order ID</div>
                            <div class="info-value"><?php echo htmlspecialchars($payment['order_id']); ?></div>
                        </div>
                        <div class="info-row">
                            <div class="info-label">UTR / Reference</div>
                            <div class="info-value"><?php echo htmlspecialchars($payment['transaction_id'] ?? 'N/A'); ?></div>
                        </div>
                    </div>
                    <div>
                        <div class="info-row">
                            <div class="info-label">Status</div>
                            <div class="info-value" style="color: #ff9800;">Awaiting Approval</div>
                        </div>
                        <div class="info-row">
                            <div class="info-label">Time</div>
                            <div class="info-value"><?php echo date('d M, H:i', strtotime($payment['created_at'])); ?></div>
                        </div>
                    </div>
                </div>

                <?php if (!empty($payment['screenshot_path'])): ?>
                    <div style="margin: 15px 0; padding: 10px; background: #f9f9f9; border-radius: 5px;">
                        <a href="/extract/<?php echo htmlspecialchars($payment['screenshot_path']); ?>" target="_blank" class="screenshot-link">
                            🖼️ View Payment Screenshot
                        </a>
                    </div>
                <?php endif; ?>

                <form method="POST" style="margin: 0;">
                    <input type="hidden" name="order_id" value="<?php echo htmlspecialchars($payment['order_id']); ?>">
                    <div class="buttons">
                        <button type="submit" name="action" value="approve" class="btn-approve">✓ Approve Payment</button>
                        <button type="submit" name="action" value="reject" class="btn-reject">✕ Reject Payment</button>
                    </div>
                </form>
            </div>
        <?php endforeach; ?>
    <?php else: ?>
        <div class="empty">
            <p>✅ No pending payments!</p>
            <p style="font-size: 14px; margin-top: 10px;">All payments have been processed.</p>
        </div>
    <?php endif; ?>
</div>
