<?php
require_once '../config/config.php';
require_once '../classes/Database.php';
require_once '../classes/Auth.php';

$db = Database::getInstance();
$auth = new Auth($db);

if (!$auth->isLoggedIn()) {
    header('Location: /extract/login.php');
    exit();
}

if (!$auth->isAdmin()) {
    header('Location: /extract/user/dashboard.php');
    exit();
}

$currentUser = $auth->getCurrentUser();
$page = $_GET['page'] ?? 'home';

/* DELETE USER HANDLER */
if (isset($_GET['delete_user'])) {

    $userId = intval($_GET['delete_user']);

    $user = $db->fetch("SELECT * FROM users WHERE id = ?", [$userId]);

    if ($user) {
        $db->query("DELETE FROM users WHERE id = ?", [$userId]);
        header("Location: dashboard.php?page=users&deleted=1");
        exit();
    } else {
        header("Location: dashboard.php?page=users&deleted=0");
        exit();
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Admin Dashboard - <?php echo APP_NAME; ?></title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://unpkg.com/feather-icons"></script>

<style>
:root {
    --primary: #007aff;
    --secondary: #f2f2f7;
    --text: #1c1c1e;
    --shadow: rgba(0,0,0,0.1);
}

body {
    background: var(--secondary);
    color: var(--text);
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
    overflow-x: hidden !important;
}

/* SIDEBAR */
.sidebar {
    height: 100vh;
    background: white;
    padding: 1.5rem;
    box-shadow: 2px 0 10px var(--shadow);
    position: fixed;
    left: 0;
    top: 0;
    width: 240px;
    z-index: 2000;
    overflow-y: auto;
}

.sidebar h5 {
    color: var(--primary);
    text-align: center;
    margin-bottom: 1.5rem;
    font-weight: 700;
}

.sidebar a {
    display: flex;
    align-items: center;
    color: var(--text);
    text-decoration: none;
    padding: 0.75rem 1rem;
    margin-bottom: 0.5rem;
    border-radius: 10px;
    font-size: 15px;
    transition: 0.2s;
}

.sidebar a.active,
.sidebar a:hover {
    background: var(--primary);
    color: #fff !important;
}

.sidebar i {
    margin-right: 0.6rem;
}

/* MAIN CONTENT */
.main-content {
    padding: 2rem;
    margin-left: 240px;
}

/* CARDS */
.card {
    border: none;
    border-radius: 16px;
    box-shadow: 0 4px 18px var(--shadow);
}

/* TABLE */
.table-responsive {
    overflow-x: auto;
}

.table th {
    background: var(--secondary);
    border: none;
    font-weight: 600;
}

.table td {
    vertical-align: middle;
}

/* MOBILE FIXES */
@media (max-width: 768px) {

    /* Make sidebar a top navbar */
    .sidebar {
        width: 100%;
        height: auto;
        position: relative;
        box-shadow: none;
        padding: 1rem;
        display: flex;
        flex-wrap: wrap;
        justify-content: space-between;
    }

    .sidebar h5 {
        width: 100%;
        text-align: center;
        margin-bottom: 1rem;
    }

    .sidebar a {
        width: 48%;
        margin-bottom: 0.7rem;
        justify-content: center;
        font-size: 14px;
        padding: 0.6rem 0.4rem;
    }

    /* Content shifts up */
    .main-content {
        margin-left: 0 !important;
        padding: 1rem;
        margin-top: 1rem;
    }

    .card {
        margin-bottom: 1rem;
    }

    body {
        overflow-x: hidden !important;
    }
}

/* XS screens */
@media (max-width: 480px) {
    .sidebar a {
        width: 100%;
    }
}
</style>

</head>
<body>

<div class="container-fluid">
    <div class="row">

        <!-- SIDEBAR -->
        <div class="col-md-2 sidebar">
            <h5>Admin Panel</h5>

            <a href="dashboard.php?page=home" class="<?= $page=='home'?'active':'' ?>">
                <i data-feather="home"></i> Dashboard
            </a>

            <a href="dashboard.php?page=users" class="<?= $page=='users'?'active':'' ?>">
                <i data-feather="users"></i> Users
            </a>

            <a href="dashboard.php?page=logs" class="<?= $page=='logs'?'active':'' ?>">
                <i data-feather="file-text"></i> Logs
            </a>

            <a href="dashboard.php?page=payment_settings" class="<?= $page=='payment_settings'?'active':'' ?>">
                <i data-feather="credit-card"></i> Payment Settings
            </a>

            <a href="dashboard.php?page=pending_payments" class="<?= $page=='pending_payments'?'active':'' ?>">
                <i data-feather="bell"></i> Pending Payments
            </a>

            <a href="dashboard.php?page=settings" class="<?= $page=='settings'?'active':'' ?>">
                <i data-feather="settings"></i> Settings
            </a>

            <a href="dashboard.php?page=chatbot" class="<?= $page=='chatbot'?'active':'' ?>">
                <i data-feather="message-circle"></i> Chatbot
            </a>

            <a href="dashboard.php?page=registration_settings" class="<?= $page=='registration_settings'?'active':'' ?>">
                <i data-feather="user-plus"></i> Registration Settings
            </a>

            <a href="dashboard.php?page=email_settings" class="<?= $page=='email_settings'?'active':'' ?>">
                <i data-feather="mail"></i> Email Settings
            </a>

            <a href="dashboard.php?page=search" class="<?= $page=='search'?'active':'' ?>">
                <i data-feather="search"></i> Search Users
            </a>

            <a href="../logout.php"><i data-feather="log-out"></i> Logout</a>
        </div>

        <!-- MAIN CONTENT -->
        <div class="col-md-10 main-content">
            <?php
                switch ($page) {
                    case 'home': include __DIR__ . '/partials/home.php'; break;
                    case 'users': include __DIR__ . '/partials/users.php'; break;
                    case 'logs': include __DIR__ . '/partials/logs.php'; break;
                    case 'payment_settings': include __DIR__ . '/partials/payment_settings.php'; break;
                    case 'pending_payments': include __DIR__ . '/partials/pending_payments.php'; break;
                    case 'settings': include __DIR__ . '/partials/settings.php'; break;
                    case 'chatbot': include __DIR__ . '/partials/chatbot.php'; break;
                    case 'registration_settings': include __DIR__ . '/partials/registration_settings_new.php'; break;
                    case 'email_settings': include __DIR__ . '/partials/email_settings.php'; break;
                    case 'search': include __DIR__ . '/partials/search.php'; break;
                    default: include __DIR__ . '/partials/home.php';
                }
            ?>
        </div>

    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>feather.replace();</script>

<div id="alert-box" class="position-fixed top-0 end-0 p-3" style="z-index:9999;width:320px;"></div>

<script>
function showAlert(type, message, timeout = 3000) {
    const box = document.getElementById("alert-box");

    const alert = document.createElement("div");
    alert.className = `alert alert-${type} alert-dismissible fade show shadow`;
    alert.innerHTML = `
        ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;

    box.appendChild(alert);

    setTimeout(() => {
        alert.classList.remove("show");
        setTimeout(() => alert.remove(), 200);
    }, timeout);
}
</script>

</body>
</html>
