<?php
/**
 * Add sample transactions for testing
 * Run this once to populate transaction data
 */

require_once 'config/config.php';
require_once 'classes/Database.php';

$db = Database::getInstance();

// Get a regular user (not admin)
$user = $db->fetch("SELECT id FROM users WHERE role = 'user' LIMIT 1");

if (!$user) {
    echo "❌ No regular user found. Please register a user first.\n";
    exit;
}

$userId = $user['id'];
echo "📝 Adding sample transactions for user ID: $userId\n\n";

// Sample transactions data
$transactions = [
    [
        'type' => 'credit',
        'amount' => 100.00,
        'description' => 'Wallet Top-up via UPI Payment',
        'balance_after' => 100.00,
        'date' => date('Y-m-d H:i:s', strtotime('-5 days'))
    ],
    [
        'type' => 'debit',
        'amount' => 10.00,
        'description' => 'Mobile Search - 9876543210',
        'balance_after' => 90.00,
        'date' => date('Y-m-d H:i:s', strtotime('-4 days'))
    ],
    [
        'type' => 'debit',
        'amount' => 10.00,
        'description' => 'Mobile Search - 9123456789',
        'balance_after' => 80.00,
        'date' => date('Y-m-d H:i:s', strtotime('-4 days 2 hours'))
    ],
    [
        'type' => 'credit',
        'amount' => 500.00,
        'description' => 'Wallet Top-up via Bank Transfer',
        'balance_after' => 580.00,
        'date' => date('Y-m-d H:i:s', strtotime('-3 days'))
    ],
    [
        'type' => 'debit',
        'amount' => 50.00,
        'description' => 'Aadhaar Search - 123456789012',
        'balance_after' => 530.00,
        'date' => date('Y-m-d H:i:s', strtotime('-2 days'))
    ],
    [
        'type' => 'debit',
        'amount' => 10.00,
        'description' => 'Mobile Search - 8765432109',
        'balance_after' => 520.00,
        'date' => date('Y-m-d H:i:s', strtotime('-1 day'))
    ],
    [
        'type' => 'debit',
        'amount' => 10.00,
        'description' => 'Mobile Search - 9988776655',
        'balance_after' => 510.00,
        'date' => date('Y-m-d H:i:s', strtotime('-1 day 3 hours'))
    ],
    [
        'type' => 'credit',
        'amount' => 200.00,
        'description' => 'Referral Bonus',
        'balance_after' => 710.00,
        'date' => date('Y-m-d H:i:s', strtotime('-12 hours'))
    ],
    [
        'type' => 'debit',
        'amount' => 5.00,
        'description' => 'Mobile Search - 7654321098',
        'balance_after' => 705.00,
        'date' => date('Y-m-d H:i:s', strtotime('-6 hours'))
    ],
    [
        'type' => 'debit',
        'amount' => 50.00,
        'description' => 'Aadhaar Search - 987654321098',
        'balance_after' => 655.00,
        'date' => date('Y-m-d H:i:s', strtotime('-1 hour'))
    ]
];

// Insert transactions
$inserted = 0;
foreach ($transactions as $txn) {
    try {
        $result = $db->insert('transactions', [
            'user_id' => $userId,
            'type' => $txn['type'],
            'amount' => $txn['amount'],
            'description' => $txn['description'],
            'balance_after' => $txn['balance_after'],
            'created_at' => $txn['date']
        ]);
        
        if ($result) {
            $inserted++;
            echo "✅ Added: {$txn['type']} - ₹{$txn['amount']} - {$txn['description']}\n";
        }
    } catch (Exception $e) {
        echo "❌ Error: {$e->getMessage()}\n";
    }
}

echo "\n📊 Summary:\n";
echo "✅ Inserted: $inserted transactions\n";
echo "💰 User ID: $userId\n";
echo "\n✨ Sample transactions added successfully!\n";
echo "🔗 Visit: /extract/user/dashboard.php → Transactions to view them\n";
?>
