<?php
require_once 'config/config.php';
require_once 'classes/Database.php';

$db = Database::getInstance();

// Add sample search data for user ID 83
$sample_searches = [
    ['user_id' => 83, 'search_query' => 'iPhone 15', 'device_type' => 'Android', 'cost' => 5.0, 'status' => 'SUCCESS'],
    ['user_id' => 83, 'search_query' => 'Samsung Galaxy', 'device_type' => 'iOS', 'cost' => 5.0, 'status' => 'SUCCESS'],
    ['user_id' => 83, 'search_query' => 'Redmi Note', 'device_type' => 'Android', 'cost' => 5.0, 'status' => 'SUCCESS'],
    ['user_id' => 83, 'search_query' => 'OnePlus 12', 'device_type' => 'iOS', 'cost' => 5.0, 'status' => 'FAILED'],
    ['user_id' => 83, 'search_query' => 'Google Pixel', 'device_type' => 'Android', 'cost' => 5.0, 'status' => 'SUCCESS'],
    ['user_id' => 83, 'search_query' => 'Mi 14', 'device_type' => 'iOS', 'cost' => 5.0, 'status' => 'SUCCESS'],
];

echo "<h3>Adding Sample Search Data for User #83</h3>";

foreach ($sample_searches as $search) {
    try {
        $db->insert('searches', $search);
        echo "✅ Added: " . $search['search_query'] . "<br>";
    } catch (Exception $e) {
        echo "❌ Error adding " . $search['search_query'] . ": " . $e->getMessage() . "<br>";
    }
}

// Verify data
echo "<h3>Verification</h3>";
$count = $db->fetch("SELECT COUNT(*) as cnt FROM searches WHERE user_id = 83");
echo "Total searches for user 83: " . $count['cnt'] . "<br>";

$searches = $db->fetchAll("SELECT * FROM searches WHERE user_id = 83");
echo "<pre>";
print_r($searches);
echo "</pre>";
?>
