<?php
/**
 * Add Registration Settings to Admin Panel
 */

require_once 'config/config.php';
require_once 'classes/Database.php';

$db = Database::getInstance();
$pdo = $db->getConnection();

try {
    echo "Adding Registration Settings...\n\n";
    
    // Check if admin_settings table exists and has registration_mode
    $result = $pdo->query("SHOW COLUMNS FROM admin_settings LIKE 'registration_mode'")->fetchAll();
    
    if (count($result) == 0) {
        $pdo->exec("ALTER TABLE admin_settings ADD COLUMN registration_mode VARCHAR(20) DEFAULT 'otp' COMMENT 'otp or direct'");
        echo "✅ Added registration_mode column\n";
    } else {
        echo "✓ registration_mode column already exists\n";
    }
    
    // Also add for OTP expiry customization
    $result = $pdo->query("SHOW COLUMNS FROM admin_settings LIKE 'otp_expiry_minutes'")->fetchAll();
    
    if (count($result) == 0) {
        $pdo->exec("ALTER TABLE admin_settings ADD COLUMN otp_expiry_minutes INT DEFAULT 5");
        echo "✅ Added otp_expiry_minutes column\n";
    } else {
        echo "✓ otp_expiry_minutes column already exists\n";
    }
    
    // Add OTP enabled/disabled flag
    $result = $pdo->query("SHOW COLUMNS FROM admin_settings LIKE 'otp_enabled'")->fetchAll();
    
    if (count($result) == 0) {
        $pdo->exec("ALTER TABLE admin_settings ADD COLUMN otp_enabled BOOLEAN DEFAULT 1");
        echo "✅ Added otp_enabled column\n";
    } else {
        echo "✓ otp_enabled column already exists\n";
    }
    
    echo "\n✅ Registration Settings Setup Complete!\n";
    
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
