# Advanced Mobile Info System

A comprehensive PHP + MySQL web application for mobile and Aadhaar information lookup with iPhone-style design and full admin control.

## Features

### 🎨 Design
- **iPhone-style UI**: White & silver theme with rounded cards and smooth animations
- **Mobile-first**: Fully responsive design optimized for smartphones
- **Modern aesthetics**: Soft shadows, gradient buttons, and clean typography
- **Dark mode**: Toggle between light and dark themes

### 🔐 Authentication
- **Unified Login**: Single login page for both users and admins
- **Auto-detection**: Admin email (admin123@gmail.com) automatically redirects to admin dashboard
- **Secure sessions**: Bcrypt password hashing and secure session management
- **Registration system**: User registration with validation

### 🔍 Search System
- **Mobile Number Search**: Lookup mobile number information
- **Aadhaar Number Search**: Secure Aadhaar verification
- **API Integration**: External API calls for data retrieval
- **Credit System**: Deduct credits per search
- **Result Display**: Beautiful card-based result presentation

### 💳 Wallet & Credits
- **Credit Management**: Each user has a wallet balance
- **Search Costs**: Configurable costs for mobile (1 credit) and Aadhaar (5 credits) searches
- **Admin Control**: Only admin can add/deduct credits
- **Transaction Logs**: Complete history of all transactions

### 👨‍💼 Admin Dashboard
- **Full Control**: Complete system management
- **User Management**: View, edit, and manage all users
- **Settings Control**: Configure search costs, API URLs, and system settings
- **Field Visibility**: Control which fields users can see
- **Search Logs**: Monitor all search activities
- **Wallet Management**: Manage user wallet balances
- **Messaging System**: Send messages to users
- **Audit Logs**: Track all admin actions

### 🛡️ Security
- **Bcrypt Hashing**: Secure password storage
- **Prepared Statements**: SQL injection prevention
- **CSRF Protection**: Form security tokens
- **Rate Limiting**: Search rate limiting
- **Data Sanitization**: Clean API responses
- **Audit Trail**: Complete action logging

## Technology Stack

- **Backend**: PHP (Procedural/OOP, no framework)
- **Database**: MySQL
- **Frontend**: HTML5, CSS3, JavaScript
- **Styling**: Bootstrap 5, Custom CSS
- **Icons**: Feather Icons
- **Fonts**: iPhone system font stack

## Installation

### 1. Database Setup

1. Create a MySQL database named `mobile_info_system`
2. Import the database schema:
   ```sql
   mysql -u root -p mobile_info_system < database/schema.sql
   ```

### 2. Configuration

1. Update database connection settings in `config/database.php`
2. Configure API URLs and settings in `config/config.php`
3. Set up your web server document root to the project folder

### 3. Web Server Configuration

#### Apache
```apache
<VirtualHost *:80>
    DocumentRoot /path/to/mobile-info-system
    <Directory /path/to/mobile-info-system>
        AllowOverride All
        Require all granted
    </Directory>
</VirtualHost>
```

#### Nginx
```nginx
server {
    listen 80;
    root /path/to/mobile-info-system;
    index index.php index.html;
    
    location / {
        try_files $uri $uri/ /index.php?$query_string;
    }
    
    location ~ \.php$ {
        fastcgi_pass unix:/var/run/php/php8.0-fpm.sock;
        fastcgi_index index.php;
        fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
        include fastcgi_params;
    }
}
```

### 4. Default Admin Account

- **Email**: admin123@gmail.com
- **Password**: password (change after first login)

## File Structure

```
mobile-info-system/
├── admin/
│   └── dashboard.php          # Admin control panel
├── classes/
│   ├── Auth.php               # Authentication system
│   ├── Database.php           # Database connection
│   ├── Search.php             # Search functionality
│   └── User.php               # User management
├── config/
│   ├── config.php             # App configuration
│   └── database.php           # Database configuration
├── database/
│   └── schema.sql             # Database schema
├── user/
│   └── dashboard.php          # User dashboard
├── index.php                  # Landing page
├── login.php                  # Unified login
├── register.php               # User registration
├── logout.php                 # Logout script
├── contact.php                # Contact page
├── terms.php                  # Terms and conditions
├── privacy.php                # Privacy policy
└── README.md                  # This file
```

## Usage

### For Users

1. **Registration**: Create a new account (if enabled)
2. **Login**: Use your email and password
3. **Search**: Enter mobile or Aadhaar number
4. **View Results**: See formatted information cards
5. **Wallet**: Check credit balance and history

### For Admins

1. **Login**: Use admin123@gmail.com to access admin dashboard
2. **Dashboard**: View system statistics and recent activity
3. **User Management**: Manage all user accounts
4. **Settings**: Configure system-wide settings
5. **Credits**: Set search costs and manage user wallets
6. **Permissions**: Control field visibility and features

## Configuration Options

### Search Costs
- Mobile Search: 1 credit (configurable)
- Aadhaar Search: 5 credits (configurable)

### Field Visibility
- Name, Operator, Circle: Always visible
- Address, DOB: Admin controlled
- Raw JSON: Admin controlled

### Features
- Registration: Enable/disable
- Export: Allow/disallow
- Share: Allow/disallow
- Raw JSON View: Admin only

## API Integration

The system includes placeholder API calls. To integrate real APIs:

1. Update API URLs in `config/config.php`
2. Implement actual API calls in `classes/Search.php`
3. Handle API responses and error cases
4. Add rate limiting and caching as needed

## Security Considerations

1. **Change Default Password**: Update admin password after first login
2. **HTTPS**: Use SSL certificate for production
3. **Database Security**: Use strong database passwords
4. **File Permissions**: Set proper file permissions
5. **Regular Updates**: Keep PHP and dependencies updated

## Troubleshooting

### Common Issues

1. **Database Connection**: Check MySQL credentials
2. **Permission Errors**: Set proper file permissions (755 for directories, 644 for files)
3. **Session Issues**: Check PHP session configuration
4. **Mail Function**: Configure PHP mail settings for email features

### Debug Mode

Enable error reporting for development:
```php
error_reporting(E_ALL);
ini_set('display_errors', 1);
```

## Support

For support and questions:
- Email: admin123@gmail.com
- Documentation: This README file
- Issues: Report through appropriate channels

## License

This project is proprietary software. All rights reserved.

## Changelog

### Version 1.0.0
- Initial release
- iPhone-style design
- Mobile and Aadhaar search
- Admin dashboard
- Wallet and credit system
- Full authentication system