<?php
require_once 'config/config.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contact Admin - <?php echo APP_NAME; ?></title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Feather Icons -->
    <script src="https://unpkg.com/feather-icons"></script>
    
    <style>
        :root {
            --primary-color: #007AFF;
            --secondary-color: #F2F2F7;
            --text-color: #1C1C1E;
            --light-gray: #F5F6F8;
            --border-color: #E5E5EA;
            --shadow-color: rgba(0, 0, 0, 0.1);
        }
        
        * {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
        }
        
        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            color: var(--text-color);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .contact-container {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 24px;
            padding: 2.5rem;
            box-shadow: 0 20px 40px var(--shadow-color);
            border: 1px solid rgba(255, 255, 255, 0.2);
            max-width: 500px;
            width: 100%;
        }
        
        .contact-header {
            text-align: center;
            margin-bottom: 2rem;
        }
        
        .contact-title {
            font-size: 2rem;
            font-weight: 700;
            background: linear-gradient(135deg, #007AFF 0%, #0056CC 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 0.5rem;
        }
        
        .contact-subtitle {
            color: #6C757D;
            font-size: 0.95rem;
        }
        
        .form-floating {
            margin-bottom: 1.5rem;
        }
        
        .form-control {
            border-radius: 12px;
            border: 2px solid var(--border-color);
            padding: 1rem;
            font-size: 1rem;
            transition: all 0.3s ease;
            background: rgba(255, 255, 255, 0.8);
        }
        
        .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.25rem rgba(0, 122, 255, 0.25);
            background: white;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #007AFF 0%, #0056CC 100%);
            border: none;
            border-radius: 25px;
            padding: 12px 30px;
            font-weight: 600;
            font-size: 1rem;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(0, 122, 255, 0.3);
            width: 100%;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(0, 122, 255, 0.4);
            background: linear-gradient(135deg, #0056CC 0%, #004499 100%);
        }
        
        .contact-info {
            background: var(--light-gray);
            border-radius: 16px;
            padding: 1.5rem;
            margin-bottom: 2rem;
            text-align: center;
        }
        
        .contact-info p {
            margin-bottom: 0.5rem;
        }
        
        .contact-info strong {
            color: var(--primary-color);
        }
    </style>
</head>
<body>
    <div class="contact-container">
        <div class="contact-header">
            <h1 class="contact-title">Contact Admin</h1>
            <p class="contact-subtitle">Get in touch with our support team</p>
        </div>
        
        <div class="contact-info">
            <p><strong>Email:</strong> admin123@gmail.com</p>
            <p><strong>Phone:</strong> +91 9876543210</p>
            <p><strong>Hours:</strong> 24/7 Support Available</p>
        </div>
        
        <form>
            <div class="form-floating">
                <input type="text" class="form-control" id="name" placeholder="Your Name" required>
                <label for="name">Your Name</label>
            </div>
            
            <div class="form-floating">
                <input type="email" class="form-control" id="email" placeholder="Your Email" required>
                <label for="email">Your Email</label>
            </div>
            
            <div class="form-floating">
                <input type="text" class="form-control" id="subject" placeholder="Subject" required>
                <label for="subject">Subject</label>
            </div>
            
            <div class="form-floating">
                <textarea class="form-control" id="message" placeholder="Your Message" style="height: 120px" required></textarea>
                <label for="message">Your Message</label>
            </div>
            
            <button type="submit" class="btn btn-primary">
                <i data-feather="send" class="me-2"></i>
                Send Message
            </button>
        </form>
        
        <div class="text-center mt-3">
            <a href="index.php" class="text-decoration-none">← Back to Home</a>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Feather Icons -->
    <script>
        feather.replace();
    </script>
</body>
</html>