<?php
// Load environment variables from .env file
if (file_exists(__DIR__ . '/../.env')) {
    $lines = file(__DIR__ . '/../.env', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        // Skip comments
        if (strpos(trim($line), '#') === 0) continue;
        
        // Skip lines without '='
        if (strpos($line, '=') === false) continue;
        
        // Parse key=value
        [$key, $value] = explode('=', $line, 2);
        $key = trim($key);
        $value = trim($value);
        
        // Set environment variable
        if (!empty($key)) {
            putenv("$key=$value");
        }
    }
}

// Database Configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'iplztpse_final');
define('DB_USER', 'root');
define('DB_PASS', '');

// App Configuration
define('APP_NAME', 'Advanced Mobile Info System');
define('APP_URL', 'https://simplechecks.xyz/extract/');
define('ADMIN_EMAIL', '');

// API Configuration
define('MOBILE_API_URL', 'https://seller-ki-mkc.taitanx.workers.dev/?mobile=');
define('AADHAAR_API_URL', 'https://ox-theta.vercel.app/fetch?key=taitaninfo&aadhaar=');

// Credit Configuration
define('MOBILE_SEARCH_COST', 1);
define('AADHAAR_SEARCH_COST', 5);

// Telegram Bot Configuration
define('TELEGRAM_BOT_TOKEN', '8547703649:AAE17yXixrbwGZvDM2Lm5SVH4rFXItovTMg'); // Add your bot token here
define('TELEGRAM_ADMIN_CHAT_ID', '6034515846'); // Add your admin chat ID here

// Security
define('BCRYPT_COST', 12);
define('SESSION_TIMEOUT', 3600);

// Features
define('ALLOW_REGISTRATION', true);
define('MAINTENANCE_MODE', false);
?>