<?php
header('Content-Type: application/json');
require_once '../config/config.php';
require_once '../classes/Database.php';
require_once '../classes/Auth.php';

$db = Database::getInstance();
$auth = new Auth($db);

// Check if admin
if (!$auth->isLoggedIn() || !$auth->isAdmin()) {
    echo json_encode(['success' => false, 'message' => 'Admin access required']);
    exit();
}

$action = $_POST['action'] ?? '';

// Get AI suggestions
if ($action === 'get_suggestions') {
    $userMessage = strtolower(trim($_POST['user_message'] ?? ''));
    
    if (empty($userMessage)) {
        echo json_encode(['success' => false]);
        exit();
    }
    
    $suggestions = [];
    
    // Keyword-based suggestions
    if (strpos($userMessage, 'credit') !== false || strpos($userMessage, 'balance') !== false || strpos($userMessage, 'wallet') !== false) {
        $suggestions[] = "You can check your balance in the Wallet section. Mobile searches cost ₹1 and Aadhaar searches cost ₹5.";
        $suggestions[] = "To add credits, go to Wallet → Add Funds and choose your payment method.";
    }
    
    if (strpos($userMessage, 'search') !== false || strpos($userMessage, 'how') !== false) {
        $suggestions[] = "Mobile Search: Enter 10-digit phone number (₹1). Aadhaar Search: Enter 12-digit Aadhaar number (₹5).";
        $suggestions[] = "Both searches give instant results. You need sufficient balance in your wallet.";
    }
    
    if (strpos($userMessage, 'payment') !== false || strpos($userMessage, 'pay') !== false) {
        $suggestions[] = "We accept UPI, Credit Card, and Bank Transfer. Payments are processed within 2 hours.";
        $suggestions[] = "After payment approval, credits are added instantly to your wallet.";
    }
    
    if (strpos($userMessage, 'problem') !== false || strpos($userMessage, 'error') !== false || strpos($userMessage, 'issue') !== false) {
        $suggestions[] = "Could you tell me more about the issue you're facing? What error did you see?";
        $suggestions[] = "I understand. Let me help you. Can you provide more details?";
    }
    
    if (strpos($userMessage, 'result') !== false || strpos($userMessage, 'data') !== false) {
        $suggestions[] = "Results may not be found if the data isn't in our database. Try another number.";
        $suggestions[] = "Make sure you have sufficient balance and entered the correct number.";
    }
    
    if (strpos($userMessage, 'refund') !== false || strpos($userMessage, 'money back') !== false) {
        $suggestions[] = "Refunds are processed within 5-7 business days after approval.";
        $suggestions[] = "Please provide your transaction ID and we'll check the status.";
    }
    
    // Default suggestions if no match
    if (empty($suggestions)) {
        $suggestions[] = "Thank you for your message. I'm here to help!";
        $suggestions[] = "Could you provide more details about your question?";
    }
    
    echo json_encode([
        'success' => true,
        'suggestions' => array_slice($suggestions, 0, 3)
    ]);
    exit();
}

echo json_encode(['success' => false, 'message' => 'Invalid action']);
?>
