<?php
require_once(__DIR__ . '/../config/config.php');
require_once(__DIR__ . '/../classes/Database.php');
require_once(__DIR__ . '/../classes/Auth.php');

session_start();

$db = Database::getInstance();
$auth = new Auth($db);

if (!$auth->isLoggedIn() || !$auth->isAdmin()) {
    http_response_code(403);
    die(json_encode(['status' => 'error', 'message' => 'Unauthorized']));
}

header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);
$orderId = $data['order_id'] ?? null;

if (!$orderId) {
    die(json_encode(['status' => 'error', 'message' => 'Order ID required']));
}

// Update order status to failed
$result = $db->update('payment_orders', 
    ['status' => 'failed'],
    'order_id = ?',
    ['order_id' => $orderId]
);

if ($result) {
    echo json_encode(['status' => 'success', 'message' => 'Payment rejected']);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Failed to reject payment']);
}
?>
