<?php
/**
 * Admin Email Configuration Guide
 * Simple setup instructions
 */
?>

<div class="container mt-5">
    <div class="row">
        <div class="col-md-8 mx-auto">
            <!-- Header -->
            <div class="card shadow-sm border-0 mb-4 bg-gradient" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">
                <div class="card-body">
                    <h2 class="card-title mb-0">
                        <i class="feather" data-feather="mail"></i> Email Configuration Setup
                    </h2>
                </div>
            </div>

            <!-- Steps -->
            <div class="card shadow-sm border-0 mb-3">
                <div class="card-body">
                    <h5 class="mb-3"><i class="feather text-primary" data-feather="step-forward"></i> Step 1: Enable 2-Factor Authentication on Gmail</h5>
                    <ol>
                        <li>Go to <a href="https://myaccount.google.com/security" target="_blank">Google Account Security</a></li>
                        <li>Find "2-Step Verification" and click it</li>
                        <li>Follow the prompts to enable 2FA</li>
                        <li>Once enabled, you'll see "App passwords" option</li>
                    </ol>
                </div>
            </div>

            <div class="card shadow-sm border-0 mb-3">
                <div class="card-body">
                    <h5 class="mb-3"><i class="feather text-primary" data-feather="key"></i> Step 2: Generate App Password</h5>
                    <ol>
                        <li>Go to <a href="https://myaccount.google.com/apppasswords" target="_blank">Google App Passwords</a></li>
                        <li>Select "Mail" from the first dropdown</li>
                        <li>Select "Windows Computer" (or your device) from the second dropdown</li>
                        <li>Click "Generate"</li>
                        <li>Google will show a 16-character password</li>
                        <li><strong>Copy this password (without spaces)</strong></li>
                    </ol>
                </div>
            </div>

            <div class="card shadow-sm border-0 mb-3">
                <div class="card-body">
                    <h5 class="mb-3"><i class="feather text-primary" data-feather="settings"></i> Step 3: Configure Email Settings</h5>
                    <ol>
                        <li>Click "Email Settings" in the admin menu</li>
                        <li>Fill in the following fields:
                            <ul>
                                <li><strong>Email Mode:</strong> SMTP (Recommended)</li>
                                <li><strong>SMTP Host:</strong> smtp.gmail.com</li>
                                <li><strong>SMTP Port:</strong> 587</li>
                                <li><strong>Encryption:</strong> TLS</li>
                                <li><strong>Email Username:</strong> your-email@gmail.com</li>
                                <li><strong>Email Password:</strong> Your 16-character App Password (without spaces)</li>
                                <li><strong>From Email:</strong> your-email@gmail.com</li>
                                <li><strong>From Name:</strong> Advanced Mobile Info (or your name)</li>
                            </ul>
                        </li>
                        <li>Click "Save Email Settings"</li>
                    </ol>
                </div>
            </div>

            <div class="card shadow-sm border-0 mb-3">
                <div class="card-body">
                    <h5 class="mb-3"><i class="feather text-primary" data-feather="send"></i> Step 4: Test Email Sending</h5>
                    <ol>
                        <li>In the Email Settings section, click "Send Test Email"</li>
                        <li>Enter your email address</li>
                        <li>Click "Send Test Email"</li>
                        <li>Check your email inbox (may take 1-2 minutes)</li>
                        <li>If not in inbox, check spam folder</li>
                        <li>✓ If you receive the test email, everything is working!</li>
                    </ol>
                </div>
            </div>

            <!-- Important Notes -->
            <div class="alert alert-warning" role="alert">
                <h5 class="alert-heading"><i class="feather" data-feather="alert-triangle"></i> Important Notes</h5>
                <ul class="mb-0">
                    <li>🔐 <strong>Never use your main Gmail password</strong> - Only use App Passwords</li>
                    <li>📧 <strong>From Email must match</strong> - Use the same email as Mail Username</li>
                    <li>⏱️ <strong>Emails may take 1-2 minutes</strong> to arrive</li>
                    <li>📬 <strong>Check spam folder</strong> if email doesn't arrive in inbox</li>
                    <li>🔓 <strong>Keep credentials secure</strong> - They're stored encrypted in the database</li>
                </ul>
            </div>

            <!-- Troubleshooting -->
            <div class="card shadow-sm border-0 mb-3">
                <div class="card-header bg-light">
                    <h5 class="mb-0"><i class="feather text-danger" data-feather="alert-circle"></i> Troubleshooting</h5>
                </div>
                <div class="card-body">
                    <table class="table">
                        <tr>
                            <td><strong>Problem</strong></td>
                            <td><strong>Solution</strong></td>
                        </tr>
                        <tr>
                            <td>Email not sending</td>
                            <td>Check SMTP credentials. Try sending a test email.</td>
                        </tr>
                        <tr>
                            <td>Authentication failed</td>
                            <td>App Password has spaces. Remove all spaces from the password.</td>
                        </tr>
                        <tr>
                            <td>Connection timeout</td>
                            <td>Check internet connection. Verify SMTP host and port are correct.</td>
                        </tr>
                        <tr>
                            <td>Email in spam</td>
                            <td>Mark as "Not spam" in Gmail. This usually happens initially.</td>
                        </tr>
                        <tr>
                            <td>Still not working?</td>
                            <td>Check error_log file in project root for detailed errors.</td>
                        </tr>
                    </table>
                </div>
            </div>

            <!-- Go to Settings Button -->
            <div class="text-center mb-4">
                <a href="dashboard.php?page=email_settings" class="btn btn-primary btn-lg">
                    <i class="feather" data-feather="arrow-right"></i> Go to Email Settings
                </a>
            </div>
        </div>
    </div>
</div>

<script>
    feather.replace();
</script>
