<?php
session_start();

// Set a test user ID for testing
if (!isset($_SESSION['user_id'])) {
    $_SESSION['user_id'] = 1; // Use your actual user ID
    $_SESSION['user_name'] = 'Test User';
}

echo "<h2>Chat API Test</h2>";
echo "<p>Testing API accessibility...</p>";

// Test 1: Check if API file exists
$api_file = __DIR__ . '/api/chat_api.php';
if (file_exists($api_file)) {
    echo "✓ API file exists at: $api_file<br>";
} else {
    echo "✗ API file NOT found at: $api_file<br>";
    echo "<strong>Creating api folder...</strong><br>";

    if (!is_dir(__DIR__ . '/api')) {
        mkdir(__DIR__ . '/api', 0755, true);
        echo "✓ Created api folder<br>";
    }
}

// Test 2: Check database connection
require_once 'db.php';
if ($conn) {
    echo "✓ Database connected<br>";

    // Check if tables exist
    $result = mysqli_query($conn, "SHOW TABLES LIKE 'chat_messages'");
    if (mysqli_num_rows($result) > 0) {
        echo "✓ Table 'chat_messages' exists<br>";
    } else {
        echo "✗ Table 'chat_messages' NOT found<br>";
        echo "<a href='setup_chat_db.php'>Click here to create tables</a><br>";
    }
} else {
    echo "✗ Database connection failed<br>";
}

// Test 3: Test API endpoint
echo "<br><h3>Testing API Endpoint:</h3>";
echo "<button onclick='testAPI()'>Test Send Message</button>";
echo "<div id='result' style='margin-top: 10px; padding: 10px; background: #f0f0f0;'></div>";

?>

<script>
    async function testAPI() {
        const resultDiv = document.getElementById('result');
        resultDiv.innerHTML = 'Testing...';

        try {
            const formData = new FormData();
            formData.append('action', 'send');
            formData.append('message', 'Hello, this is a test!');
            formData.append('mode', 'ai');

            const response = await fetch('api/chat_api.php', {
                method: 'POST',
                body: formData
            });

            const text = await response.text();
            resultDiv.innerHTML = '<strong>Response:</strong><br><pre>' + text + '</pre>';

            // Try to parse as JSON
            try {
                const data = JSON.parse(text);
                resultDiv.innerHTML += '<br><strong>Parsed JSON:</strong><br><pre>' + JSON.stringify(data, null, 2) + '</pre>';
            } catch (e) {
                resultDiv.innerHTML += '<br><strong>Not valid JSON</strong>';
            }

        } catch (error) {
            resultDiv.innerHTML = '<strong>Error:</strong> ' + error.message;
        }
    }
</script>

<style>
    body {
        font-family: Arial, sans-serif;
        max-width: 800px;
        margin: 50px auto;
        padding: 20px;
    }

    button {
        background: #667eea;
        color: white;
        border: none;
        padding: 10px 20px;
        border-radius: 5px;
        cursor: pointer;
    }

    button:hover {
        background: #5568d3;
    }

    pre {
        background: white;
        padding: 10px;
        border-radius: 5px;
        overflow-x: auto;
    }
</style>