<?php
require_once 'db.php';

echo "<h2>Setting up Admin Settings...</h2>";

// Create admin_settings table
$sql = "CREATE TABLE IF NOT EXISTS admin_settings (
    id INT AUTO_INCREMENT PRIMARY KEY,
    setting_key VARCHAR(100) UNIQUE NOT NULL,
    setting_value TEXT NOT NULL,
    setting_type ENUM('number', 'text', 'boolean') DEFAULT 'text',
    description TEXT,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_key (setting_key)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if (mysqli_query($conn, $sql)) {
    echo "✓ Table 'admin_settings' created<br>";
} else {
    echo "✗ Error: " . mysqli_error($conn) . "<br>";
}

// Insert default settings
$settings = [
    ['daily_search_limit', '10', 'number', 'Maximum searches allowed per user per day'],
    ['enable_voice_search', '1', 'boolean', 'Enable voice search feature'],
    ['enable_messaging', '1', 'boolean', 'Enable in-app messaging'],
    ['maintenance_mode', '0', 'boolean', 'Enable maintenance mode']
];

echo "<br><h3>Inserting Default Settings...</h3>";

foreach ($settings as $setting) {
    list($key, $value, $type, $desc) = $setting;

    $insert_sql = "INSERT INTO admin_settings (setting_key, setting_value, setting_type, description) 
                   VALUES ('$key', '$value', '$type', '$desc')
                   ON DUPLICATE KEY UPDATE setting_value=setting_value";

    if (mysqli_query($conn, $insert_sql)) {
        echo "✓ Added: $key = $value<br>";
    } else {
        echo "✗ Error: " . mysqli_error($conn) . "<br>";
    }
}

echo "<br>✅ <strong>Admin Settings Setup Complete!</strong><br>";
echo "<br><a href='admin/settings.php' style='
    display: inline-block;
    padding: 10px 20px;
    background: linear-gradient(135deg, #FF3B30 0%, #D32F2F 100%);
    color: white;
    text-decoration: none;
    border-radius: 8px;
    font-weight: 600;
'>Go to Settings</a>";
?>