<?php
session_start();
require_once 'db.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit();
}

$user_id = $_SESSION['user_id'];
$error = '';
$success = '';

// Fetch user data
$sql = "SELECT * FROM users WHERE id = '$user_id'";
$result = mysqli_query($conn, $sql);
$user = mysqli_fetch_assoc($result);

// Get toast messages from session
$toast_success = isset($_SESSION['toast_success']) ? $_SESSION['toast_success'] : '';
$toast_error = isset($_SESSION['toast_error']) ? $_SESSION['toast_error'] : '';

// Clear toast messages
unset($_SESSION['toast_success']);
unset($_SESSION['toast_error']);

// Handle profile picture upload
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['profile_picture']) && $_FILES['profile_picture']['error'] == 0) {
    $file = $_FILES['profile_picture'];
    $allowed = ['jpg', 'jpeg', 'png', 'gif'];
    $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));

    if (in_array($ext, $allowed) && $file['size'] < 2000000) {
        $filename = 'user_' . $user_id . '_' . time() . '.' . $ext;
        $path = 'uploads/profiles/' . $filename;

        if (move_uploaded_file($file['tmp_name'], $path)) {
            mysqli_query($conn, "UPDATE users SET profile_picture = '$path' WHERE id = $user_id");
            $user['profile_picture'] = $path;
            $_SESSION['toast_success'] = 'Profile picture updated successfully!';
            log_activity($user_id, 'profile_update', 'Profile Picture Updated', 'User updated profile picture');
            header('Location: profile.php');
            exit();
        } else {
            $error = 'Failed to upload file';
        }
    } else {
        $error = 'Invalid file. Use JPG, PNG or GIF under 2MB';
    }
}

// Handle profile update
elseif ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['name'])) {
    $name = sanitize_input($_POST['name']);
    $email = sanitize_input($_POST['email']);
    $mobile = sanitize_input($_POST['mobile']);

    // Validation
    if (empty($name) || empty($email) || empty($mobile)) {
        $error = 'All fields are required';
    } elseif (!validate_email($email)) {
        $error = 'Invalid email format';
    } elseif (!validate_mobile($mobile)) {
        $error = 'Mobile number must be 10-15 digits';
    } else {
        // Check if email is taken by another user
        $check_email = "SELECT id FROM users WHERE email = '$email' AND id != '$user_id'";
        $email_result = mysqli_query($conn, $check_email);

        // Check if mobile is taken by another user
        $check_mobile = "SELECT id FROM users WHERE mobile = '$mobile' AND id != '$user_id'";
        $mobile_result = mysqli_query($conn, $check_mobile);

        if (mysqli_num_rows($email_result) > 0) {
            $error = 'Email already in use by another account';
        } elseif (mysqli_num_rows($mobile_result) > 0) {
            $error = 'Mobile number already in use by another account';
        } else {
            // Update user profile
            $update_sql = "UPDATE users SET name = '$name', email = '$email', mobile = '$mobile' WHERE id = '$user_id'";

            if (mysqli_query($conn, $update_sql)) {
                // Update session
                $_SESSION['user_name'] = $name;
                $_SESSION['user_email'] = $email;

                // Refresh user data
                $result = mysqli_query($conn, $sql);
                $user = mysqli_fetch_assoc($result);

                // Log activity
                log_activity($user_id, 'profile_update', 'Profile Updated', 'User updated profile information');

                $success = 'Profile updated successfully!';
            } else {
                $error = 'Failed to update profile. Please try again.';
            }
        }
    }
}

// Handle password change
elseif ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['change_password'])) {
    $current_password = $_POST['current_password'] ?? '';
    $new_password = $_POST['new_password'] ?? '';
    $confirm_password = $_POST['confirm_password'] ?? '';

    // Validation
    if (empty($current_password) || empty($new_password) || empty($confirm_password)) {
        $error = 'All password fields are required';
    } elseif (strlen($new_password) < 6) {
        $error = 'New password must be at least 6 characters';
    } elseif ($new_password !== $confirm_password) {
        $error = 'New passwords do not match';
    } else {
        // Verify current password
        if (password_verify($current_password, $user['password'])) {
            // Hash new password
            $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);

            // Update password
            $update_pass_sql = "UPDATE users SET password = '$hashed_password' WHERE id = '$user_id'";

            if (mysqli_query($conn, $update_pass_sql)) {
                // Log activity
                log_activity($user_id, 'password_change', 'Password Changed', 'User changed their password');

                $_SESSION['toast_success'] = 'Password changed successfully!';
                header('Location: profile.php');
                exit();
            } else {
                $error = 'Failed to update password. Please try again.';
            }
        } else {
            $error = 'Current password is incorrect';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="theme-color" content="#667eea">
    <title>Profile - Mobile App</title>
    <link rel="stylesheet" href="style.css">
</head>

<body>
    <div class="mobile-container" style="padding-bottom: 80px; padding-top: 10px;">
        <div class="dashboard-wrapper">
            <!-- Header -->
            <div class="profile-header">
                <a href="dashboard.php" class="back-button">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M19 12H5M12 19l-7-7 7-7" />
                    </svg>
                </a>
                <h1 class="header-title">My Profile</h1>
                <div class="header-spacer"></div>
            </div>

            <!-- Profile Avatar Section -->
            <div class="profile-avatar-section">
                <?php $avatar = $user['profile_picture'] ?? 'uploads/profiles/default.svg'; ?>
                <div class="profile-avatar" style="position: relative;">
                    <?php if ($avatar && file_exists($avatar)): ?>
                        <img src="<?php echo $avatar; ?>?v=<?php echo time(); ?>" alt="Profile"
                            style="width: 100%; height: 100%; border-radius: 50%; object-fit: cover;">
                    <?php else: ?>
                        <?php echo strtoupper(substr($user['name'], 0, 1)); ?>
                    <?php endif; ?>
                </div>
                <h2 class="profile-name"><?php echo htmlspecialchars($user['name']); ?></h2>
                <p class="profile-member-since">IP: <?php echo $_SERVER['REMOTE_ADDR']; ?></p>

                <!-- Upload Photo Button -->
                <form method="POST" enctype="multipart/form-data" style="margin-top: 12px;">
                    <input type="file" name="profile_picture" accept="image/*" id="profilePicInput"
                        style="display: none;" onchange="this.form.submit()">
                    <label for="profilePicInput" class="btn btn-primary"
                        style="cursor: pointer; display: inline-block; font-size: 13px; padding: 8px 16px;">
                        📸 Change Photo
                    </label>
                </form>
                <p style="font-size: 11px; color: var(--text-secondary); margin-top: 6px;">JPG, PNG or GIF. Max 2MB</p>
            </div>

            <!-- Profile Form -->
            <form method="POST" action="" class="profile-form">
                <div class="form-section">
                    <h3 class="section-title">Personal Information</h3>

                    <div class="form-group">
                        <label for="name">Full Name</label>
                        <input type="text" id="name" name="name" value="<?php echo htmlspecialchars($user['name']); ?>"
                            required autocomplete="name">
                    </div>

                    <div class="form-group">
                        <label for="email">Email Address</label>
                        <input type="email" id="email" name="email"
                            value="<?php echo htmlspecialchars($user['email']); ?>" required autocomplete="email">
                    </div>

                    <div class="form-group">
                        <label for="mobile">Mobile Number</label>
                        <input type="tel" id="mobile" name="mobile"
                            value="<?php echo htmlspecialchars($user['mobile']); ?>" required pattern="[0-9]{10,15}"
                            autocomplete="tel">
                    </div>
                </div>

                <div class="form-section">
                    <h3 class="section-title">Account Details</h3>

                    <div class="info-row">
                        <span class="info-label">User ID</span>
                        <span class="info-value">#<?php echo str_pad($user['id'], 5, '0', STR_PAD_LEFT); ?></span>
                    </div>

                    <div class="info-row">
                        <span class="info-label">Account Created</span>
                        <span class="info-value"><?php echo date('d M Y', strtotime($user['created_at'])); ?></span>
                    </div>

                    <div class="info-row">
                        <span class="info-label">Account Status</span>
                        <span class="info-value status-active">Active</span>
                    </div>
                </div>

                <!-- Save Button -->
                <button type="submit" class="btn btn-primary" style="margin-top: 20px;">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M19 21H5a2 2 0 01-2-2V5a2 2 0 012-2h11l5 5v11a2 2 0 01-2 2z" />
                        <polyline points="17 21 17 13 7 13 7 21" />
                        <polyline points="7 3 7 8 15 8" />
                    </svg>
                    Save Changes
                </button>
            </form>

            <!-- Change Password Section -->
            <form method="POST" action="" class="profile-form">
                <div class="form-section">
                    <h3 class="section-title">🔒 Change Password</h3>

                    <div class="form-group">
                        <label for="current_password">Current Password</label>
                        <input type="password" id="current_password" name="current_password"
                            placeholder="Enter current password" required autocomplete="current-password">
                    </div>

                    <div class="form-group">
                        <label for="new_password">New Password</label>
                        <input type="password" id="new_password" name="new_password"
                            placeholder="Enter new password (min 6 characters)" required minlength="6"
                            autocomplete="new-password">
                    </div>

                    <div class="form-group">
                        <label for="confirm_password">Confirm New Password</label>
                        <input type="password" id="confirm_password" name="confirm_password"
                            placeholder="Re-enter new password" required minlength="6" autocomplete="new-password">
                    </div>

                    <button type="submit" name="change_password" class="btn btn-primary" style="margin-top: 10px;">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                            stroke-width="2">
                            <rect x="3" y="11" width="18" height="11" rx="2" ry="2" />
                            <path d="M7 11V7a5 5 0 0 1 10 0v4" />
                        </svg>
                        Change Password
                    </button>
                </div>
            </form>

            <!-- Danger Zone -->
            <div class="form-section danger-section">
                <h3 class="section-title">Danger Zone</h3>
                <a href="logout.php" class="btn btn-danger">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                        <path
                            d="M17 7l-1.41 1.41L18.17 11H8v2h10.17l-2.58 2.58L17 17l5-5-5-5zM4 5h8V3H4c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h8v-2H4V5z" />
                    </svg>
                    Sign Out
                </a>
            </div>

            <!-- Bottom spacing for nav -->
            <div style="height: 80px;"></div>
        </div>
    </div>

    <!-- Bottom Navigation -->
    <?php include 'navbar.php'; ?>

    <script src="script.js"></script>
    <script>
        // Show toast notifications from session (redirects)
        <?php if ($toast_success): ?>
            showToast('<?php echo addslashes($toast_success); ?>', 'success');
        <?php endif; ?>

        <?php if ($toast_error): ?>
            showToast('<?php echo addslashes($toast_error); ?>', 'error');
        <?php endif; ?>

        // Show toast notifications from PHP (same page)
        <?php if ($success): ?>
            showToast('<?php echo addslashes($success); ?>', 'success');
        <?php endif; ?>

        <?php if ($error): ?>
            showToast('<?php echo addslashes($error); ?>', 'error');
        <?php endif; ?>
    </script>

    <!-- AI Chatbot -->
    <?php include 'chat_widget.php'; ?>
</body>

</html>