<?php
// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    return;
}

// Get current page
$current_page = basename($_SERVER['PHP_SELF']);
?>

<style>
    /* Modern Bottom Navigation - Rainbow Theme */
    .modern-bottom-nav {
        position: fixed;
        bottom: 0;
        left: 0;
        right: 0;

        padding: 8px 16px;
        padding-bottom: calc(8px + env(safe-area-inset-bottom));
        z-index: 1000;
    }

    .nav-container {
        max-width: 800px;
        margin: 0 auto;
        background: #FFFFFF;
        border-radius: 16px;
        padding: 10px 20px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
        position: relative;
    }

    /* Bottom notch */
    .nav-container::after {
        content: '';
        position: absolute;
        bottom: -8px;
        left: 50%;
        transform: translateX(-50%);
        width: 40px;
        height: 12px;
        background: #FFFFFF;
        border-radius: 50% 50% 0 0;
    }

    .nav-item {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        text-decoration: none;
        transition: all 0.3s ease;
        padding: 6px 4px;
        border-radius: 10px;
        position: relative;
        gap: 3px;
    }

    .nav-item svg {
        width: 22px;
        height: 22px;
        transition: all 0.3s ease;
    }

    .nav-item span {
        font-size: 10px;
        font-weight: 500;
        font-family: -apple-system, BlinkMacSystemFont, "SF Pro Display", "SF Pro Text", system-ui, sans-serif;
        transition: all 0.3s ease;
    }

    /* Rainbow colors for each icon */
    .nav-item:nth-child(1) svg {
        fill: #FF6B6B;
    }

    .nav-item:nth-child(1) span {
        color: #FF6B6B;
    }

    .nav-item:nth-child(2) svg {
        fill: #FFA500;
    }

    .nav-item:nth-child(2) span {
        color: #FFA500;
    }

    .nav-item:nth-child(3) svg {
        fill: #E91E63;
    }

    .nav-item:nth-child(3) span {
        color: #E91E63;
    }

    .nav-item:nth-child(4) svg {
        fill: #4A90E2;
    }

    .nav-item:nth-child(4) span {
        color: #4A90E2;
    }

    .nav-item:nth-child(5) svg {
        fill: #9B59B6;
    }

    .nav-item:nth-child(5) span {
        color: #9B59B6;
    }

    .nav-item.active svg {
        transform: scale(1.15);
        filter: drop-shadow(0 4px 8px currentColor);
    }

    .nav-item.active span {
        font-weight: 600;
    }

    .nav-item:hover:not(.active) svg {
        transform: scale(1.08);
        opacity: 0.8;
    }

    .nav-item:hover:not(.active) span {
        opacity: 0.8;
    }

    .nav-item:active {
        transform: scale(0.95);
    }

    /* Responsive */
    @media (max-width: 768px) {
        .nav-container {
            padding: 16px 20px;
        }

        .nav-item svg {
            width: 28px;
            height: 28px;
        }
    }

    @media (max-width: 480px) {
        .nav-container {
            padding: 14px 16px;
            border-radius: 30px;
        }

        .nav-item {
            padding: 8px;
        }

        .nav-item svg {
            width: 26px;
            height: 26px;
        }
    }
</style>

<nav class="modern-bottom-nav">
    <div class="nav-container">
        <!-- Home Icon -->
        <a href="dashboard.php" class="nav-item <?php echo ($current_page == 'dashboard.php') ? 'active' : ''; ?>">
            <svg viewBox="0 0 24 24">
                <path d="M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8z" />
            </svg>
            <span>Home</span>
        </a>


        <!-- History/Clock Icon -->
        <a href="history.php" class="nav-item <?php echo ($current_page == 'history.php') ? 'active' : ''; ?>">
            <svg viewBox="0 0 24 24">
                <path
                    d="M12 2C6.5 2 2 6.5 2 12s4.5 10 10 10 10-4.5 10-10S17.5 2 12 2zm4.2 14.2L11 13V7h1.5v5.2l4.5 2.7-.8 1.3z" />
            </svg>
            <span>History</span>
        </a>

        <!-- Search Icon -->
        <a href="search.php" class="nav-item <?php echo ($current_page == 'search.php') ? 'active' : ''; ?>">
            <svg viewBox="0 0 24 24">
                <path
                    d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z" />
            </svg>
            <span>Search</span>
        </a>

        <!-- Chat Icon -->
        <a href="#" class="nav-item" onclick="event.preventDefault(); toggleChat();">
            <svg viewBox="0 0 24 24">
                <path d="M20 2H4c-1.1 0-2 .9-2 2v18l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 14H6l-2 2V4h16v12z"/>
            </svg>
            <span>Chat</span>
        </a>
        <!-- User Icon -->
        <a href="profile.php" class="nav-item <?php echo ($current_page == 'profile.php') ? 'active' : ''; ?>">
            <svg viewBox="0 0 24 24">
                <path
                    d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z" />
            </svg>
            <span>Profile</span>
        </a>

    </div>
</nav>