<?php
session_start();
require_once 'db.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit();
}

$user_id = $_SESSION['user_id'];
$user_name = $_SESSION['user_name'];
$user_email = $_SESSION['user_email'];

// Get toast messages
$toast_success = isset($_SESSION['toast_success']) ? $_SESSION['toast_success'] : '';
$toast_error = isset($_SESSION['toast_error']) ? $_SESSION['toast_error'] : '';

// Check if this is first login (show welcome notice)
$show_welcome = isset($_SESSION['show_welcome_notice']) ? true : false;
unset($_SESSION['show_welcome_notice']);

// Clear toast messages from session
unset($_SESSION['toast_success']);
unset($_SESSION['toast_error']);

// Get user profile image
$user_query = "SELECT profile_image FROM users WHERE id = $user_id";
$user_result = mysqli_query($conn, $user_query);
$user_data = mysqli_fetch_assoc($user_result);
$profile_image = $user_data['profile_image'] ?? '';

// Get recent activities (only login and profile updates, not searches)
$activities_sql = "SELECT * FROM user_activities 
                   WHERE user_id = $user_id 
                   AND activity_type IN ('login', 'register', 'profile_update')
                   ORDER BY created_at DESC 
                   LIMIT 5";
$activities_result = mysqli_query($conn, $activities_sql);
$recent_activities = [];
if ($activities_result) {
    while ($row = mysqli_fetch_assoc($activities_result)) {
        $recent_activities[] = $row;
    }
}

// Get announcements for popup
$announcements_sql = "SELECT * FROM announcements WHERE status = 'active' ORDER BY created_at DESC LIMIT 5";
$announcements_result = mysqli_query($conn, $announcements_sql);
$announcements = [];
if ($announcements_result) {
    while ($row = mysqli_fetch_assoc($announcements_result)) {
        $announcements[] = $row;
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="theme-color" content="#007AFF">
    <title>Dashboard - Mobile App</title>
    <link rel="stylesheet" href="style.css">
</head>

<body>
    <div class="mobile-container" style="padding-bottom: 80px;">
        <div class="dashboard-wrapper">
            <!-- Header -->
            <div class="dashboard-header">
                <div class="user-avatar" <?php if (!empty($profile_image)): ?>style="background-image: url('<?php echo htmlspecialchars($profile_image); ?>'); background-size: cover; background-position: center;"<?php endif; ?>>
                    <?php if (empty($profile_image)): ?>
                        <?php echo strtoupper(substr($user_name, 0, 1)); ?>
                    <?php endif; ?>
                </div>
                <div class="user-info">
                    <h2 class="welcome-text">Welcome back,</h2>
                    <h1 class="user-name"><?php echo htmlspecialchars($user_name); ?></h1>
                </div>
            </div>



            <!-- Quick Actions -->
            <div class="quick-actions">
                <h3 class="section-heading">Quick Actions</h3>
                <div class="quick-action-grid">
                    <a href="profile.php" class="quick-action-item">
                        <div class="quick-action-icon"
                            style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="white">
                                <path
                                    d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z" />
                            </svg>
                        </div>
                        <span class="quick-action-label">Profile</span>
                    </a>

                    <a href="#" class="quick-action-item" onclick="event.preventDefault(); showAnnouncements();">
                        <div class="quick-action-icon"
                            style="background: linear-gradient(135deg, #FF9500 0%, #FF5E3A 100%);">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="white">
                                <path d="M18 8A6 6 0 106 8c0 7-3 9-3 9h18s-3-2-3-9M13.73 21a2 2 0 01-3.46 0" />
                            </svg>
                        </div>
                        <span class="quick-action-label">Announcements</span>
                    </a>

                    <a href="logout.php" class="quick-action-item">
                        <div class="quick-action-icon"
                            style="background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="white">
                                <path
                                    d="M17 7l-1.41 1.41L18.17 11H8v2h10.17l-2.58 2.58L17 17l5-5-5-5zM4 5h8V3H4c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h8v-2H4V5z" />
                            </svg>
                        </div>
                        <span class="quick-action-label">Logout</span>
                    </a>
                </div>
            </div>

            <!-- Stats Overview -->
            <div class="stats-overview">
                <h3 class="section-heading">Overview</h3>
                <div class="stats-grid">
                    <div class="stat-card">
                        <div class="stat-icon" style="background: rgba(0, 122, 255, 0.1);">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#007AFF"
                                stroke-width="2">
                                <circle cx="12" cy="12" r="10" />
                                <path d="M12 6v6l4 2" />
                            </svg>
                        </div>
                        <div class="stat-info">
                            <p class="stat-value">Active</p>
                            <p class="stat-label">Status</p>
                        </div>
                    </div>

                    <div class="stat-card">
                        <div class="stat-icon" style="background: rgba(52, 199, 89, 0.1);">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#34C759"
                                stroke-width="2">
                                <rect x="3" y="4" width="18" height="18" rx="2" />
                                <path d="M16 2v4M8 2v4M3 10h18" />
                            </svg>
                        </div>
                        <div class="stat-info">
                            <p class="stat-value">Today</p>
                            <p class="stat-label">Member Since</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Recent Activity -->
            <div class="recent-activity">
                <h3 class="section-heading">Recent Activity</h3>
                <div class="activity-list">
                    <?php if (count($recent_activities) > 0): ?>
                        <?php foreach ($recent_activities as $activity): ?>
                            <div class="activity-item">
                                <div class="activity-icon">
                                    <?php if ($activity['activity_type'] == 'login'): ?>
                                        <svg width="16" height="16" viewBox="0 0 24 24" fill="#007AFF">
                                            <path
                                                d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z" />
                                        </svg>
                                    <?php elseif ($activity['activity_type'] == 'register'): ?>
                                        <svg width="16" height="16" viewBox="0 0 24 24" fill="#34C759">
                                            <path
                                                d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z" />
                                        </svg>
                                    <?php elseif ($activity['activity_type'] == 'profile_update'): ?>
                                        <svg width="16" height="16" viewBox="0 0 24 24" fill="#FF9500">
                                            <path
                                                d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z" />
                                        </svg>
                                    <?php else: ?>
                                        <svg width="16" height="16" viewBox="0 0 24 24" fill="#8E8E93">
                                            <path
                                                d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z" />
                                        </svg>
                                    <?php endif; ?>
                                </div>
                                <div class="activity-content">
                                    <p class="activity-title"><?php echo htmlspecialchars($activity['activity_title']); ?></p>
                                    <p class="activity-time"><?php echo time_ago($activity['created_at']); ?></p>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <div class="activity-item">
                            <div class="activity-icon">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="#8E8E93">
                                    <path
                                        d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z" />
                                </svg>
                            </div>
                            <div class="activity-content">
                                <p class="activity-title">No recent activity</p>
                                <p class="activity-time">Start using the app to see your activities here</p>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Bottom Navigation -->
    <?php include 'navbar.php'; ?>

    <script src="script.js"></script>
    <script>
        // Show toast notifications from PHP
        <?php if ($toast_success): ?>
            showToast('<?php echo addslashes($toast_success); ?>', 'success');
        <?php endif; ?>

        <?php if ($toast_error): ?>
            showToast('<?php echo addslashes($toast_error); ?>', 'error');
        <?php endif; ?>

        // Welcome Notice
        <?php if ($show_welcome): ?>
            showWelcomeNotice();
        <?php endif; ?>

        function showWelcomeNotice() {
            // Create notice overlay
            const overlay = document.createElement('div');
            overlay.id = 'welcomeNoticeOverlay';
            overlay.style.cssText = `
                position: fixed;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                background: rgba(0, 0, 0, 0.5);
                z-index: 9999;
                display: flex;
                align-items: center;
                justify-content: center;
                animation: fadeIn 0.3s ease;
            `;

            // Create notice box
            const notice = document.createElement('div');
            notice.style.cssText = `
                background: white;
                border-radius: 20px;
                padding: 30px;
                max-width: 90%;
                width: 400px;
                box-shadow: 0 10px 40px rgba(0, 0, 0, 0.3);
                animation: slideUp 0.3s ease;
                position: relative;
            `;

            notice.innerHTML = `
                <style>
                    @keyframes fadeIn {
                        from { opacity: 0; }
                        to { opacity: 1; }
                    }
                    @keyframes slideUp {
                        from { transform: translateY(50px); opacity: 0; }
                        to { transform: translateY(0); opacity: 1; }
                    }
                </style>
                <button onclick="closeWelcomeNotice()" style="
                    position: absolute;
                    top: 15px;
                    right: 15px;
                    background: #F5F5F7;
                    border: none;
                    width: 32px;
                    height: 32px;
                    border-radius: 50%;
                    cursor: pointer;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    transition: all 0.2s;
                " onmouseover="this.style.background='#E5E5EA'" onmouseout="this.style.background='#F5F5F7'">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M18 6L6 18M6 6l12 12"/>
                    </svg>
                </button>
                <div style="text-align: center;">
                    <div style="
                        width: 80px;
                        height: 80px;
                        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                        border-radius: 50%;
                        margin: 0 auto 20px;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                    ">
                        <svg width="40" height="40" viewBox="0 0 24 24" fill="none" stroke="white" stroke-width="2">
                            <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"/>
                            <circle cx="12" cy="7" r="4"/>
                        </svg>
                    </div>
                    <h2 style="
                        font-size: 24px;
                        font-weight: 700;
                        color: #1C1C1E;
                        margin-bottom: 12px;
                    ">Welcome Back, <?php echo htmlspecialchars($user_name); ?>! 👋</h2>
                    <p style="
                        font-size: 15px;
                        color: #8E8E93;
                        line-height: 1.5;
                        margin-bottom: 20px;
                    ">
                        You've successfully logged in. Explore your dashboard and enjoy all features!
                    </p>
                    <div style="
                        background: #F5F5F7;
                        border-radius: 12px;
                        padding: 16px;
                        margin-bottom: 20px;
                    ">
                        <p style="
                            font-size: 13px;
                            color: #1C1C1E;
                            margin: 0;
                        ">
                            💡 <strong>Tip:</strong> Currently we don't have all data !
                        </p>
                    </div>
                    <div style="
                        font-size: 12px;
                        color: #8E8E93;
                    ">
                        Auto-closing in <span id="countdown">5</span> seconds...
                    </div>
                </div>
            `;

            overlay.appendChild(notice);
            document.body.appendChild(overlay);

            // Countdown timer
            let seconds = 5;
            const countdownEl = document.getElementById('countdown');
            const timer = setInterval(() => {
                seconds--;
                if (countdownEl) {
                    countdownEl.textContent = seconds;
                }
                if (seconds <= 0) {
                    clearInterval(timer);
                    closeWelcomeNotice();
                }
            }, 1000);

            // Store timer ID for manual close
            window.welcomeNoticeTimer = timer;
        }

        function closeWelcomeNotice() {
            const overlay = document.getElementById('welcomeNoticeOverlay');
            if (overlay) {
                overlay.style.animation = 'fadeOut 0.3s ease';
                setTimeout(() => {
                    overlay.remove();
                }, 300);
            }
            if (window.welcomeNoticeTimer) {
                clearInterval(window.welcomeNoticeTimer);
            }
        }

        // Show Announcements Popup
        function showAnnouncements() {
            const announcements = <?php echo json_encode($announcements); ?>;

            // Create overlay
            const overlay = document.createElement('div');
            overlay.id = 'announcementOverlay';
            overlay.style.cssText = `
                position: fixed;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                background: rgba(0, 0, 0, 0.5);
                z-index: 9999;
                display: flex;
                align-items: center;
                justify-content: center;
                animation: fadeIn 0.3s ease;
                padding: 20px;
            `;

            // Create popup
            const popup = document.createElement('div');
            popup.style.cssText = `
                background: white;
                border-radius: 20px;
                max-width: 500px;
                width: 100%;
                max-height: 80vh;
                overflow: hidden;
                box-shadow: 0 10px 40px rgba(0, 0, 0, 0.3);
                animation: slideUp 0.3s ease;
                display: flex;
                flex-direction: column;
            `;

            let announcementsHTML = '';

            if (announcements.length > 0) {
                announcements.forEach((announcement, index) => {
                    const date = new Date(announcement.created_at);
                    const formattedDate = date.toLocaleDateString('en-US', {
                        month: 'short',
                        day: 'numeric',
                        year: 'numeric'
                    });

                    announcementsHTML += `
                        <div style="
                            padding: 16px;
                            border-bottom: 1px solid #F5F5F7;
                            ${index === announcements.length - 1 ? 'border-bottom: none;' : ''}
                        ">
                            <div style="display: flex; align-items: start; gap: 12px;">
                                <div style="
                                    width: 40px;
                                    height: 40px;
                                    border-radius: 50%;
                                    background: linear-gradient(135deg, #FF9500 0%, #FF5E3A 100%);
                                    display: flex;
                                    align-items: center;
                                    justify-content: center;
                                    flex-shrink: 0;
                                ">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="white">
                                        <path d="M18 8A6 6 0 106 8c0 7-3 9-3 9h18s-3-2-3-9M13.73 21a2 2 0 01-3.46 0"/>
                                    </svg>
                                </div>
                                <div style="flex: 1;">
                                    <h4 style="
                                        margin: 0 0 4px 0;
                                        font-size: 16px;
                                        font-weight: 600;
                                        color: #1C1C1E;
                                    ">${announcement.title}</h4>
                                    <p style="
                                        margin: 0 0 8px 0;
                                        font-size: 14px;
                                        color: #3C3C43;
                                        line-height: 1.5;
                                    ">${announcement.content}</p>
                                    <p style="
                                        margin: 0;
                                        font-size: 12px;
                                        color: #8E8E93;
                                    ">${formattedDate}</p>
                                </div>
                            </div>
                        </div>
                    `;
                });
            } else {
                announcementsHTML = `
                    <div style="
                        padding: 40px 20px;
                        text-align: center;
                        color: #8E8E93;
                    ">
                        <svg width="60" height="60" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" style="margin: 0 auto 16px; opacity: 0.5;">
                            <path d="M18 8A6 6 0 106 8c0 7-3 9-3 9h18s-3-2-3-9M13.73 21a2 2 0 01-3.46 0"/>
                        </svg>
                        <h3 style="margin: 0 0 8px 0; font-size: 16px; color: #1C1C1E;">No Announcements</h3>
                        <p style="margin: 0; font-size: 14px;">There are no active announcements at the moment.</p>
                    </div>
                `;
            }

            popup.innerHTML = `
                <div style="
                    padding: 20px;
                    border-bottom: 1px solid #F5F5F7;
                    display: flex;
                    align-items: center;
                    justify-content: space-between;
                ">
                    <h2 style="
                        margin: 0;
                        font-size: 20px;
                        font-weight: 700;
                        color: #1C1C1E;
                    ">📢 Announcements</h2>
                    <button onclick="closeAnnouncements()" style="
                        background: #F5F5F7;
                        border: none;
                        width: 32px;
                        height: 32px;
                        border-radius: 50%;
                        cursor: pointer;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        transition: all 0.2s;
                    " onmouseover="this.style.background='#E5E5EA'" onmouseout="this.style.background='#F5F5F7'">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M18 6L6 18M6 6l12 12"/>
                        </svg>
                    </button>
                </div>
                <div style="
                    flex: 1;
                    overflow-y: auto;
                ">
                    ${announcementsHTML}
                </div>
            `;

            overlay.appendChild(popup);
            document.body.appendChild(overlay);

            // Close on overlay click
            overlay.addEventListener('click', (e) => {
                if (e.target === overlay) {
                    closeAnnouncements();
                }
            });
        }

        function closeAnnouncements() {
            const overlay = document.getElementById('announcementOverlay');
            if (overlay) {
                overlay.style.animation = 'fadeOut 0.3s ease';
                setTimeout(() => {
                    overlay.remove();
                }, 300);
            }
        }
    </script>

    <!-- AI Chatbot -->
    <?php include 'chat_widget.php'; ?>
</body>

</html>