-- Create announcements table
CREATE TABLE IF NOT EXISTS announcements (
    id INT AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(255) NOT NULL,
    content TEXT NOT NULL,
    status ENUM('active', 'inactive') DEFAULT 'active',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_status (status),
    INDEX idx_created_at (created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insert sample announcements
INSERT INTO announcements (title, content, status) VALUES
('Welcome to Our Platform!', 'Thank you for joining us. Explore all features and enjoy your experience.', 'active'),
('System Update', 'We have updated our system with new features and improvements.', 'active'),
('Important Notice', 'Currently we don''t have all mobile number data. We are working to expand our database.', 'active');
