<?php
session_start();
require_once '../db.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'error' => 'Not authenticated']);
    exit();
}

$user_id = $_SESSION['user_id'];
$action = $_POST['action'] ?? $_GET['action'] ?? '';

// Get all conversations
if ($action === 'get_conversations') {
    $sql = "SELECT DISTINCT 
            c.id as conversation_id,
            CASE 
                WHEN c.user1_id = $user_id THEN c.user2_id 
                ELSE c.user1_id 
            END as other_user_id,
            u.name as other_user_name,
            u.profile_picture,
            c.last_message_time,
            (SELECT COUNT(*) FROM messages WHERE conversation_id = c.id AND receiver_id = $user_id AND is_read = 0) as unread_count,
            (SELECT message FROM messages WHERE conversation_id = c.id ORDER BY created_at DESC LIMIT 1) as last_message
            FROM conversations c
            LEFT JOIN users u ON (CASE WHEN c.user1_id = $user_id THEN c.user2_id ELSE c.user1_id END) = u.id
            WHERE c.user1_id = $user_id OR c.user2_id = $user_id
            ORDER BY c.last_message_time DESC";

    $result = mysqli_query($conn, $sql);
    $conversations = [];

    if ($result) {
        while ($row = mysqli_fetch_assoc($result)) {
            $conversations[] = $row;
        }
    }

    echo json_encode(['success' => true, 'conversations' => $conversations]);
    exit();
}

// Get messages for a conversation
if ($action === 'get_messages') {
    $other_user_id = (int) ($_GET['user_id'] ?? 0);

    if (!$other_user_id) {
        echo json_encode(['success' => false, 'error' => 'Invalid user ID']);
        exit();
    }

    // Get or create conversation
    $conv_sql = "SELECT id FROM conversations 
                 WHERE (user1_id = $user_id AND user2_id = $other_user_id) 
                 OR (user1_id = $other_user_id AND user2_id = $user_id)";
    $conv_result = mysqli_query($conn, $conv_sql);

    if (mysqli_num_rows($conv_result) == 0) {
        echo json_encode(['success' => true, 'messages' => []]);
        exit();
    }

    $conversation = mysqli_fetch_assoc($conv_result);
    $conversation_id = $conversation['id'];

    // Mark messages as read
    $mark_read_sql = "UPDATE messages SET is_read = 1 
                      WHERE conversation_id = $conversation_id AND receiver_id = $user_id";
    mysqli_query($conn, $mark_read_sql);

    // Get messages
    $msg_sql = "SELECT m.*, u.name as sender_name 
                FROM messages m
                LEFT JOIN users u ON m.sender_id = u.id
                WHERE m.conversation_id = $conversation_id
                ORDER BY m.created_at ASC";

    $msg_result = mysqli_query($conn, $msg_sql);
    $messages = [];

    if ($msg_result) {
        while ($row = mysqli_fetch_assoc($msg_result)) {
            $messages[] = $row;
        }
    }

    echo json_encode(['success' => true, 'messages' => $messages]);
    exit();
}

// Send message
if ($action === 'send_message') {
    $receiver_id = (int) ($_POST['receiver_id'] ?? 0);
    $message = trim($_POST['message'] ?? '');

    if (!$receiver_id || empty($message)) {
        echo json_encode(['success' => false, 'error' => 'Invalid data']);
        exit();
    }

    $message = mysqli_real_escape_string($conn, $message);

    // Check if blocked
    $block_check = "SELECT id FROM blocked_users 
                    WHERE (blocker_id = $receiver_id AND blocked_id = $user_id)
                    OR (blocker_id = $user_id AND blocked_id = $receiver_id)";
    $block_result = mysqli_query($conn, $block_check);

    if (mysqli_num_rows($block_result) > 0) {
        echo json_encode(['success' => false, 'error' => 'Cannot send message']);
        exit();
    }

    // Get or create conversation
    $conv_sql = "SELECT id FROM conversations 
                 WHERE (user1_id = $user_id AND user2_id = $receiver_id) 
                 OR (user1_id = $receiver_id AND user2_id = $user_id)";
    $conv_result = mysqli_query($conn, $conv_sql);

    if (mysqli_num_rows($conv_result) == 0) {
        // Create new conversation
        $create_conv = "INSERT INTO conversations (user1_id, user2_id) VALUES ($user_id, $receiver_id)";
        mysqli_query($conn, $create_conv);
        $conversation_id = mysqli_insert_id($conn);
    } else {
        $conversation = mysqli_fetch_assoc($conv_result);
        $conversation_id = $conversation['id'];
    }

    // Insert message
    $insert_msg = "INSERT INTO messages (conversation_id, sender_id, receiver_id, message) 
                   VALUES ($conversation_id, $user_id, $receiver_id, '$message')";

    if (mysqli_query($conn, $insert_msg)) {
        $message_id = mysqli_insert_id($conn);

        // Update conversation
        $update_conv = "UPDATE conversations 
                        SET last_message_id = $message_id, last_message_time = NOW() 
                        WHERE id = $conversation_id";
        mysqli_query($conn, $update_conv);

        echo json_encode(['success' => true, 'message_id' => $message_id]);
    } else {
        echo json_encode(['success' => false, 'error' => 'Failed to send message']);
    }
    exit();
}

// Get all users for new conversation
if ($action === 'get_users') {
    $search = mysqli_real_escape_string($conn, $_GET['search'] ?? '');

    $sql = "SELECT id, name, email, profile_picture FROM users 
            WHERE id != $user_id AND role = 'user'";

    if ($search) {
        $sql .= " AND (name LIKE '%$search%' OR email LIKE '%$search%')";
    }

    $sql .= " LIMIT 20";

    $result = mysqli_query($conn, $sql);
    $users = [];

    if ($result) {
        while ($row = mysqli_fetch_assoc($result)) {
            $users[] = $row;
        }
    }

    echo json_encode(['success' => true, 'users' => $users]);
    exit();
}

// Delete conversation
if ($action === 'delete_conversation') {
    $conversation_id = (int) ($_POST['conversation_id'] ?? 0);

    if (!$conversation_id) {
        echo json_encode(['success' => false, 'error' => 'Invalid conversation ID']);
        exit();
    }

    $sql = "DELETE FROM conversations 
            WHERE id = $conversation_id 
            AND (user1_id = $user_id OR user2_id = $user_id)";

    if (mysqli_query($conn, $sql)) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'error' => 'Failed to delete']);
    }
    exit();
}

echo json_encode(['success' => false, 'error' => 'Invalid action']);
?>