-- Admin Settings Table
CREATE TABLE IF NOT EXISTS admin_settings (
    id INT AUTO_INCREMENT PRIMARY KEY,
    setting_key VARCHAR(100) UNIQUE NOT NULL,
    setting_value TEXT NOT NULL,
    setting_type ENUM('number', 'text', 'boolean') DEFAULT 'text',
    description TEXT,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_key (setting_key)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insert default settings
INSERT INTO admin_settings (setting_key, setting_value, setting_type, description) VALUES
('daily_search_limit', '10', 'number', 'Maximum searches allowed per user per day'),
('enable_voice_search', '1', 'boolean', 'Enable voice search feature'),
('enable_messaging', '1', 'boolean', 'Enable in-app messaging'),
('maintenance_mode', '0', 'boolean', 'Enable maintenance mode')
ON DUPLICATE KEY UPDATE setting_value=setting_value;
