-- Add role and status columns to users table
ALTER TABLE users 
ADD COLUMN role ENUM('user','admin') DEFAULT 'user' AFTER password,
ADD COLUMN status ENUM('active','disabled') DEFAULT 'active' AFTER role;

-- Create default admin user (password: admin123)
INSERT INTO users (name, email, mobile, password, role, status) 
VALUES ('Admin User', 'admin@app.com', '9999999999', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin', 'active')
ON DUPLICATE KEY UPDATE role = 'admin';

-- Add indexes for better performance
ALTER TABLE users ADD INDEX idx_role (role);
ALTER TABLE users ADD INDEX idx_status (status);
