<?php
session_start();
require_once '../db.php';

// Check if admin is logged in
if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit();
}

$admin_name = $_SESSION['admin_name'];

// Get toast messages from session
$toast_success = isset($_SESSION['toast_success']) ? $_SESSION['toast_success'] : '';
$toast_error = isset($_SESSION['toast_error']) ? $_SESSION['toast_error'] : '';

// Clear toast messages
unset($_SESSION['toast_success']);
unset($_SESSION['toast_error']);

// Handle user actions
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['action']) && isset($_POST['user_id'])) {
        $user_id = (int) $_POST['user_id'];
        $action = $_POST['action'];

        if ($action == 'toggle_status') {
            $current_status_query = "SELECT status FROM users WHERE id = $user_id";
            $result = mysqli_query($conn, $current_status_query);
            $user = mysqli_fetch_assoc($result);

            $new_status = ($user['status'] == 'active') ? 'disabled' : 'active';
            $update_query = "UPDATE users SET status = '$new_status' WHERE id = $user_id";

            if (mysqli_query($conn, $update_query)) {
                $_SESSION['toast_success'] = "User status updated to " . ucfirst($new_status) . "!";
                log_activity($_SESSION['admin_id'], 'user_status_change', 'User Status Changed', "Changed user #$user_id status to $new_status");
            } else {
                $_SESSION['toast_error'] = "Failed to update user status: " . mysqli_error($conn);
            }

            // Redirect to prevent form resubmission
            header('Location: users.php');
            exit();

        } elseif ($action == 'delete') {
            $delete_query = "DELETE FROM users WHERE id = $user_id AND role = 'user'";

            if (mysqli_query($conn, $delete_query)) {
                $_SESSION['toast_success'] = "User deleted successfully!";
                log_activity($_SESSION['admin_id'], 'user_delete', 'User Deleted', "Deleted user #$user_id");
            } else {
                $_SESSION['toast_error'] = "Failed to delete user: " . mysqli_error($conn);
            }

            // Redirect to prevent form resubmission
            header('Location: users.php');
            exit();
        }
    }
}

// Get all users with search count
$users_query = "SELECT u.*, 
                COUNT(s.id) as search_count 
                FROM users u 
                LEFT JOIN searches s ON u.id = s.user_id 
                WHERE u.role = 'user' 
                GROUP BY u.id 
                ORDER BY u.created_at DESC";
$users_result = mysqli_query($conn, $users_query);
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="theme-color" content="#FF3B30">
    <title>User Management - Admin</title>
    <link rel="stylesheet" href="../style.css">
    <style>
        .user-list {
            display: flex;
            flex-direction: column;
            gap: 12px;
            margin-bottom: 80px;
        }

        .user-card {
            background: white;
            border-radius: 12px;
            padding: 16px;
            border: 1px solid var(--border-color);
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
        }

        .user-card-header {
            display: flex;
            align-items: center;
            gap: 12px;
            margin-bottom: 12px;
        }

        .user-card-avatar {
            width: 48px;
            height: 48px;
            border-radius: 50%;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 18px;
            font-weight: 700;
            flex-shrink: 0;
        }

        .user-card-info {
            flex: 1;
        }

        .user-card-name {
            font-size: 15px;
            font-weight: 600;
            color: var(--text-primary);
            margin-bottom: 2px;
        }

        .user-card-email {
            font-size: 13px;
            color: var(--text-secondary);
        }

        .user-card-details {
            display: flex;
            flex-direction: column;
            gap: 8px;
            margin-bottom: 12px;
            padding: 12px;
            background: var(--bg-secondary);
            border-radius: 8px;
        }

        .user-detail-row {
            display: flex;
            justify-content: space-between;
            font-size: 13px;
        }

        .user-detail-label {
            color: var(--text-secondary);
        }

        .user-detail-value {
            color: var(--text-primary);
            font-weight: 500;
        }

        .user-status-badge {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
        }

        .status-active {
            background: rgba(52, 199, 89, 0.1);
            color: #34C759;
        }

        .status-disabled {
            background: rgba(255, 59, 48, 0.1);
            color: #FF3B30;
        }

        .user-card-actions {
            display: flex;
            gap: 8px;
        }

        .action-btn {
            flex: 1;
            padding: 10px;
            border: none;
            border-radius: 8px;
            font-size: 13px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 6px;
        }

        .btn-toggle {
            background: rgba(0, 122, 255, 0.1);
            color: #007AFF;
        }

        .btn-toggle:active {
            background: rgba(0, 122, 255, 0.2);
        }

        .btn-delete {
            background: rgba(255, 59, 48, 0.1);
            color: #FF3B30;
        }

        .btn-delete:active {
            background: rgba(255, 59, 48, 0.2);
        }
    </style>
</head>

<body>
    <div class="mobile-container" style="padding-bottom: 80px;">
        <div class="dashboard-wrapper">
            <!-- Header -->
            <div class="profile-header">
                <a href="dashboard.php" class="back-button">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M19 12H5M12 19l-7-7 7-7" />
                    </svg>
                </a>
                <h1 class="header-title">User Management</h1>
                <div class="header-spacer"></div>
            </div>

            <!-- User List -->
            <div class="user-list">
                <?php if (mysqli_num_rows($users_result) > 0): ?>
                    <?php while ($user = mysqli_fetch_assoc($users_result)): ?>
                        <div class="user-card">
                            <div class="user-card-header">
                                <div class="user-card-avatar">
                                    <?php echo strtoupper(substr($user['name'], 0, 1)); ?>
                                </div>
                                <div class="user-card-info">
                                    <div class="user-card-name"><?php echo htmlspecialchars($user['name']); ?></div>
                                    <div class="user-card-email"><?php echo htmlspecialchars($user['email']); ?></div>
                                </div>
                            </div>

                            <div class="user-card-details">
                                <div class="user-detail-row">
                                    <span class="user-detail-label">Mobile:</span>
                                    <span class="user-detail-value"><?php echo htmlspecialchars($user['mobile']); ?></span>
                                </div>
                                <div class="user-detail-row">
                                    <span class="user-detail-label">Status:</span>
                                    <span class="user-status-badge status-<?php echo $user['status']; ?>">
                                        <?php echo ucfirst($user['status']); ?>
                                    </span>
                                </div>
                                <div class="user-detail-row">
                                    <span class="user-detail-label">Joined:</span>
                                    <span
                                        class="user-detail-value"><?php echo date('M d, Y', strtotime($user['created_at'])); ?></span>
                                </div>
                                <div class="user-detail-row">
                                    <span class="user-detail-label">🔍 Searches:</span>
                                    <span class="user-detail-value" style="font-weight: 600; color: #007AFF;">
                                        <?php echo $user['search_count']; ?>
                                    </span>
                                </div>
                            </div>

                            <div class="user-card-actions">
                                <form method="POST" style="flex: 1;">
                                    <input type="hidden" name="user_id" value="<?php echo $user['id']; ?>">
                                    <input type="hidden" name="action" value="toggle_status">
                                    <button type="submit" class="action-btn btn-toggle">
                                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                            stroke-width="2">
                                            <rect x="1" y="5" width="22" height="14" rx="7" ry="7" />
                                            <circle cx="16" cy="12" r="3" />
                                        </svg>
                                        <?php echo $user['status'] == 'active' ? 'Disable' : 'Enable'; ?>
                                    </button>
                                </form>

                                <form method="POST" style="flex: 1;"
                                    onsubmit="return confirm('Are you sure you want to delete this user?');">
                                    <input type="hidden" name="user_id" value="<?php echo $user['id']; ?>">
                                    <input type="hidden" name="action" value="delete">
                                    <button type="submit" class="action-btn btn-delete">
                                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                            stroke-width="2">
                                            <polyline points="3 6 5 6 21 6" />
                                            <path
                                                d="M19 6v14a2 2 0 01-2 2H7a2 2 0 01-2-2V6m3 0V4a2 2 0 012-2h4a2 2 0 012 2v2" />
                                        </svg>
                                        Delete
                                    </button>
                                </form>
                            </div>
                        </div>
                    <?php endwhile; ?>
                <?php else: ?>
                    <div class="user-card">
                        <p style="text-align: center; color: var(--text-secondary);">No users found</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <?php include 'navbar.php'; ?>

    <script src="../script.js"></script>
    <script>
        <?php if ($toast_success): ?>
            showToast('<?php echo addslashes($toast_success); ?>', 'success');
        <?php endif; ?>

        <?php if ($toast_error): ?>
            showToast('<?php echo addslashes($toast_error); ?>', 'error');
        <?php endif; ?>
    </script>
</body>

</html>