<?php
session_start();
require_once '../db.php';

if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit();
}

// Handle settings update
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $daily_limit = (int)$_POST['daily_search_limit'];
    
    $sql = "UPDATE admin_settings SET setting_value = '$daily_limit' WHERE setting_key = 'daily_search_limit'";
    
    if (mysqli_query($conn, $sql)) {
        $_SESSION['toast_success'] = 'Settings updated successfully!';
    } else {
        $_SESSION['toast_error'] = 'Failed to update settings';
    }
    
    header('Location: settings.php');
    exit();
}

// Get current settings
$settings_sql = "SELECT * FROM admin_settings";
$settings_result = mysqli_query($conn, $settings_sql);
$settings = [];

if ($settings_result) {
    while ($row = mysqli_fetch_assoc($settings_result)) {
        $settings[$row['setting_key']] = $row;
    }
}

$toast_success = $_SESSION['toast_success'] ?? '';
$toast_error = $_SESSION['toast_error'] ?? '';
unset($_SESSION['toast_success'], $_SESSION['toast_error']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Settings</title>
    <link rel="stylesheet" href="../style.css">
    <style>
        .settings-container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
            padding-bottom: 100px;
        }

        .settings-header {
            margin-bottom: 24px;
        }

        .settings-header h1 {
            font-size: 24px;
            font-weight: 700;
            color: var(--text-primary);
            margin-bottom: 8px;
        }

        .settings-card {
            background: white;
            border-radius: 16px;
            padding: 24px;
            margin-bottom: 16px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.05);
        }

        .setting-item {
            margin-bottom: 20px;
        }

        .setting-item:last-child {
            margin-bottom: 0;
        }

        .setting-label {
            font-size: 14px;
            font-weight: 600;
            color: var(--text-primary);
            margin-bottom: 8px;
            display: block;
        }

        .setting-description {
            font-size: 12px;
            color: var(--text-secondary);
            margin-bottom: 12px;
        }

        .setting-input {
            width: 100%;
            padding: 12px 16px;
            border: 2px solid #E5E5EA;
            border-radius: 12px;
            font-size: 16px;
            outline: none;
        }

        .setting-input:focus {
            border-color: #007AFF;
        }

        .save-btn {
            width: 100%;
            padding: 16px;
            background: linear-gradient(135deg, #FF3B30 0%, #D32F2F 100%);
            color: white;
            border: none;
            border-radius: 12px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            margin-top: 20px;
        }

        .save-btn:hover {
            opacity: 0.9;
        }
    </style>
</head>
<body>
    <div class="settings-container">
        <div class="settings-header">
            <h1>⚙️ Admin Settings</h1>
            <p style="color: var(--text-secondary); font-size: 14px;">Configure system settings</p>
        </div>

        <form method="POST">
            <div class="settings-card">
                <h2 style="font-size: 18px; font-weight: 600; margin-bottom: 20px;">Search Settings</h2>
                
                <div class="setting-item">
                    <label class="setting-label">Daily Search Limit per User</label>
                    <p class="setting-description">Maximum number of searches a user can perform per day</p>
                    <input type="number" name="daily_search_limit" class="setting-input" 
                           value="<?php echo $settings['daily_search_limit']['setting_value'] ?? 10; ?>" 
                           min="1" max="1000" required>
                </div>
            </div>

            <button type="submit" class="save-btn">💾 Save Settings</button>
        </form>
    </div>

    <?php include 'navbar.php'; ?>

    <script src="../script.js"></script>
    <script>
        <?php if ($toast_success): ?>
            showToast('<?php echo addslashes($toast_success); ?>', 'success');
        <?php endif; ?>

        <?php if ($toast_error): ?>
            showToast('<?php echo addslashes($toast_error); ?>', 'error');
        <?php endif; ?>
    </script>
</body>
</html>
