<?php
session_start();
require_once '../db.php';

// Check if admin is logged in
if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit();
}

$admin_id = $_SESSION['admin_id'];
$admin_name = $_SESSION['admin_name'];

// Get toast messages
$toast_success = isset($_SESSION['toast_success']) ? $_SESSION['toast_success'] : '';
$toast_error = isset($_SESSION['toast_error']) ? $_SESSION['toast_error'] : '';

// Clear toast messages
unset($_SESSION['toast_success']);
unset($_SESSION['toast_error']);

// Get statistics
$total_users = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as count FROM users WHERE role = 'user'"))['count'];
$active_users = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as count FROM users WHERE role = 'user' AND status = 'active'"))['count'];
$disabled_users = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as count FROM users WHERE role = 'user' AND status = 'disabled'"))['count'];
$total_searches = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as count FROM searches"))['count'] ?? 0;
$today_searches = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as count FROM searches WHERE DATE(created_at) = CURDATE()"))['count'] ?? 0;
$total_messages = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as count FROM messages"))['count'] ?? 0;

// Database size
$db_size_sql = "SELECT ROUND(SUM(data_length + index_length) / 1024 / 1024, 2) AS size_mb 
                FROM information_schema.TABLES 
                WHERE table_schema = '" . DB_NAME . "'";
$db_size = mysqli_fetch_assoc(mysqli_query($conn, $db_size_sql))['size_mb'] ?? 0;

// Get recent users
$recent_users_sql = "SELECT * FROM users WHERE role='user' ORDER BY created_at DESC LIMIT 5";
$recent_users = mysqli_query($conn, $recent_users_sql);

// Get recent activities (with error handling)
$recent_activities = [];
if (function_exists('get_recent_activities')) {
    $recent_activities = get_recent_activities($admin_id, 5);
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link rel="stylesheet" href="../style.css">
    <style>
        /* Compact Stat Cards */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(140px, 1fr));
            gap: 12px;
            margin-bottom: 20px;
        }

        .stat-card {
            background: white;
            border-radius: 12px;
            padding: 14px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .stat-icon {
            width: 36px;
            height: 36px;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }

        .stat-icon svg {
            width: 18px;
            height: 18px;
        }

        .stat-info {
            flex: 1;
            min-width: 0;
        }

        .stat-value {
            font-size: 20px;
            font-weight: 700;
            color: var(--text-primary);
            margin: 0 0 2px 0;
        }

        .stat-label {
            font-size: 11px;
            color: var(--text-secondary);
            margin: 0;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        .quick-actions {
            margin: 20px 0;
        }

        .quick-action-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
            gap: 12px;
        }

        .quick-action-item {
            background: white;
            padding: 16px;
            border-radius: 12px;
            text-align: center;
            text-decoration: none;
            color: var(--text-primary);
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
            transition: transform 0.2s;
        }

        .quick-action-item:hover {
            transform: translateY(-2px);
        }

        .quick-action-icon {
            width: 48px;
            height: 48px;
            margin: 0 auto 12px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
    </style>
</head>

<body>
    <div class="mobile-container" style="padding-bottom: 80px;">
        <div class="dashboard-wrapper">
            <!-- Header -->
            <div class="dashboard-header">
                <div class="user-avatar" style="background: linear-gradient(135deg, #FF3B30 0%, #D32F2F 100%);">
                    <?php echo strtoupper(substr($admin_name, 0, 1)); ?>
                </div>
                <div class="user-info">
                    <h2 class="welcome-text">Admin Panel</h2>
                    <h1 class="user-name"><?php echo htmlspecialchars($admin_name); ?></h1>
                </div>
            </div>

            <!-- Stats Overview -->
            <div class="stats-overview">
                <h3 class="section-heading">Statistics</h3>
                <div class="stats-grid">
                    <!-- Total Users -->
                    <div class="stat-card">
                        <div class="stat-icon" style="background: rgba(0, 122, 255, 0.1);">
                            <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="#007AFF"
                                stroke-width="2">
                                <path d="M17 21v-2a4 4 0 00-4-4H5a4 4 0 00-4 4v2" />
                                <circle cx="9" cy="7" r="4" />
                                <path d="M23 21v-2a4 4 0 00-3-3.87M16 3.13a4 4 0 010 7.75" />
                            </svg>
                        </div>
                        <div class="stat-info">
                            <p class="stat-value"><?php echo $total_users; ?></p>
                            <p class="stat-label">Total Users</p>
                        </div>
                    </div>

                    <!-- Active Users -->
                    <div class="stat-card">
                        <div class="stat-icon" style="background: rgba(52, 199, 89, 0.1);">
                            <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="#34C759"
                                stroke-width="2">
                                <path d="M22 11.08V12a10 10 0 11-5.93-9.14" />
                                <polyline points="22 4 12 14.01 9 11.01" />
                            </svg>
                        </div>
                        <div class="stat-info">
                            <p class="stat-value"><?php echo $active_users; ?></p>
                            <p class="stat-label">Active</p>
                        </div>
                    </div>

                    <!-- Disabled Users -->
                    <div class="stat-card">
                        <div class="stat-icon" style="background: rgba(255, 59, 48, 0.1);">
                            <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="#FF3B30"
                                stroke-width="2">
                                <circle cx="12" cy="12" r="10" />
                                <line x1="15" y1="9" x2="9" y2="15" />
                                <line x1="9" y1="9" x2="15" y2="15" />
                            </svg>
                        </div>
                        <div class="stat-info">
                            <p class="stat-value"><?php echo $disabled_users; ?></p>
                            <p class="stat-label">Disabled</p>
                        </div>
                    </div>

                    <!-- Total Searches -->
                    <div class="stat-card">
                        <div class="stat-icon" style="background: rgba(255, 149, 0, 0.1);">
                            <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="#FF9500"
                                stroke-width="2">
                                <circle cx="11" cy="11" r="8" />
                                <path d="m21 21-4.35-4.35" />
                            </svg>
                        </div>
                        <div class="stat-info">
                            <p class="stat-value"><?php echo $total_searches; ?></p>
                            <p class="stat-label">Searches</p>
                        </div>
                    </div>

                    <!-- Messages -->
                    <div class="stat-card">
                        <div class="stat-icon" style="background: rgba(88, 86, 214, 0.1);">
                            <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="#5856D6"
                                stroke-width="2">
                                <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z" />
                            </svg>
                        </div>
                        <div class="stat-info">
                            <p class="stat-value"><?php echo $total_messages; ?></p>
                            <p class="stat-label">Messages</p>
                        </div>
                    </div>

                    <!-- Database Size -->
                    <div class="stat-card">
                        <div class="stat-icon" style="background: rgba(175, 82, 222, 0.1);">
                            <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="#AF52DE"
                                stroke-width="2">
                                <ellipse cx="12" cy="5" rx="9" ry="3" />
                                <path d="M21 12c0 1.66-4 3-9 3s-9-1.34-9-3" />
                                <path d="M3 5v14c0 1.66 4 3 9 3s9-1.34 9-3V5" />
                            </svg>
                        </div>
                        <div class="stat-info">
                            <p class="stat-value"><?php echo $db_size; ?> MB</p>
                            <p class="stat-label">DB Size</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="quick-actions">
                <h3 class="section-heading">Quick Actions</h3>
                <div class="quick-action-grid">
                    <a href="users.php" class="quick-action-item">
                        <div class="quick-action-icon"
                            style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="white">
                                <path
                                    d="M16 11c1.66 0 2.99-1.34 2.99-3S17.66 5 16 5c-1.66 0-3 1.34-3 3s1.34 3 3 3zm-8 0c1.66 0 2.99-1.34 2.99-3S9.66 5 8 5C6.34 5 5 6.34 5 8s1.34 3 3 3zm0 2c-2.33 0-7 1.17-7 3.5V19h14v-2.5c0-2.33-4.67-3.5-7-3.5zm8 0c-.29 0-.62.02-.97.05 1.16.84 1.97 1.97 1.97 3.45V19h6v-2.5c0-2.33-4.67-3.5-7-3.5z" />
                            </svg>
                        </div>
                        <span class="quick-action-label">Manage Users</span>
                    </a>

                    <a href="announcements.php" class="quick-action-item">
                        <div class="quick-action-icon"
                            style="background: linear-gradient(135deg, #FF9500 0%, #FF5E3A 100%);">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="white">
                                <path d="M18 8A6 6 0 106 8c0 7-3 9-3 9h18s-3-2-3-9M13.73 21a2 2 0 01-3.46 0" />
                            </svg>
                        </div>
                        <span class="quick-action-label">Announcements</span>
                    </a>

                    <a href="settings.php" class="quick-action-item">
                        <div class="quick-action-icon"
                            style="background: linear-gradient(135deg, #34C759 0%, #30D158 100%);">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="white">
                                <path
                                    d="M19.14,12.94c0.04-0.3,0.06-0.61,0.06-0.94c0-0.32-0.02-0.64-0.07-0.94l2.03-1.58c0.18-0.14,0.23-0.41,0.12-0.61 l-1.92-3.32c-0.12-0.22-0.37-0.29-0.59-0.22l-2.39,0.96c-0.5-0.38-1.03-0.7-1.62-0.94L14.4,2.81c-0.04-0.24-0.24-0.41-0.48-0.41 h-3.84c-0.24,0-0.43,0.17-0.47,0.41L9.25,5.35C8.66,5.59,8.12,5.92,7.63,6.29L5.24,5.33c-0.22-0.08-0.47,0-0.59,0.22L2.74,8.87 C2.62,9.08,2.66,9.34,2.86,9.48l2.03,1.58C4.84,11.36,4.8,11.69,4.8,12s0.02,0.64,0.07,0.94l-2.03,1.58 c-0.18,0.14-0.23,0.41-0.12,0.61l1.92,3.32c0.12,0.22,0.37,0.29,0.59,0.22l2.39-0.96c0.5,0.38,1.03,0.7,1.62,0.94l0.36,2.54 c0.05,0.24,0.24,0.41,0.48,0.41h3.84c0.24,0,0.44-0.17,0.47-0.41l0.36-2.54c0.59-0.24,1.13-0.56,1.62-0.94l2.39,0.96 c0.22,0.08,0.47,0,0.59-0.22l1.92-3.32c0.12-0.22,0.07-0.47-0.12-0.61L19.14,12.94z M12,15.6c-1.98,0-3.6-1.62-3.6-3.6 s1.62-3.6,3.6-3.6s3.6,1.62,3.6,3.6S13.98,15.6,12,15.6z" />
                            </svg>
                        </div>
                        <span class="quick-action-label">Settings</span>
                    </a>

                    <a href="logout.php" class="quick-action-item">
                        <div class="quick-action-icon"
                            style="background: linear-gradient(135deg, #FF3B30 0%, #D32F2F 100%);">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="white">
                                <path
                                    d="M17 7l-1.41 1.41L18.17 11H8v2h10.17l-2.58 2.58L17 17l5-5-5-5zM4 5h8V3H4c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h8v-2H4V5z" />
                            </svg>
                        </div>
                        <span class="quick-action-label">Logout</span>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <?php include 'navbar.php'; ?>

    <script src="../script.js"></script>
    <script>
        <?php if ($toast_success): ?>
            showToast('<?php echo addslashes($toast_success); ?>', 'success');
        <?php endif; ?>

        <?php if ($toast_error): ?>
            showToast('<?php echo addslashes($toast_error); ?>', 'error');
        <?php endif; ?>
    </script>
</body>

</html>