<?php
// Admin Chat Widget - Shows user conversations
if (!isset($_SESSION['admin_id'])) {
    return;
}

// Get users with pending messages
$pending_chats_sql = "SELECT DISTINCT u.id, u.name, u.profile_picture,
    (SELECT COUNT(*) FROM chat_messages WHERE user_id = u.id AND is_user = 1 AND is_admin = 0) as message_count,
    (SELECT message FROM chat_messages WHERE user_id = u.id ORDER BY created_at DESC LIMIT 1) as last_message
    FROM users u
    WHERE EXISTS (SELECT 1 FROM chat_messages WHERE user_id = u.id AND is_user = 1)
    ORDER BY (SELECT created_at FROM chat_messages WHERE user_id = u.id ORDER BY created_at DESC LIMIT 1) DESC
    LIMIT 10";

$pending_result = mysqli_query($conn, $pending_chats_sql);
$pending_chats = [];
$total_pending = 0;

if ($pending_result) {
    while ($row = mysqli_fetch_assoc($pending_result)) {
        $pending_chats[] = $row;
        $total_pending += $row['message_count'];
    }
}
?>

<style>
    /* Admin Chat Button */
    .admin-chat-btn {
        position: fixed;
        bottom: 20px;
        right: 20px;
        width: 60px;
        height: 60px;
        background: linear-gradient(135deg, #FF3B30 0%, #D32F2F 100%);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        box-shadow: 0 4px 20px rgba(255, 59, 48, 0.4);
        cursor: pointer;
        z-index: 999;
        transition: all 0.3s ease;
    }

    .admin-chat-btn:hover {
        transform: scale(1.1);
        box-shadow: 0 6px 24px rgba(255, 59, 48, 0.6);
    }

    .admin-chat-btn svg {
        width: 30px;
        height: 30px;
        fill: white;
    }

    .admin-chat-badge {
        position: absolute;
        top: -4px;
        right: -4px;
        background: #FFD700;
        color: #000;
        border-radius: 50%;
        width: 24px;
        height: 24px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 12px;
        font-weight: 700;
        border: 2px solid white;
    }

    /* Admin Chat Panel */
    .admin-chat-panel {
        position: fixed;
        bottom: 20px;
        right: 20px;
        width: 90%;
        max-width: 400px;
        height: 600px;
        background: white;
        border-radius: 20px;
        box-shadow: 0 8px 40px rgba(0, 0, 0, 0.2);
        display: none;
        flex-direction: column;
        z-index: 1000;
        overflow: hidden;
    }

    .admin-chat-panel.active {
        display: flex;
    }

    .admin-chat-header {
        background: linear-gradient(135deg, #FF3B30 0%, #D32F2F 100%);
        color: white;
        padding: 16px 20px;
        display: flex;
        align-items: center;
        justify-content: space-between;
    }

    .admin-chat-header h3 {
        font-size: 16px;
        font-weight: 600;
        margin: 0;
    }

    .admin-chat-close {
        background: none;
        border: none;
        color: white;
        cursor: pointer;
        padding: 4px;
    }

    .admin-users-list {
        flex: 1;
        overflow-y: auto;
        background: #F5F5F7;
    }

    .admin-user-item {
        padding: 16px;
        border-bottom: 1px solid #E5E5EA;
        cursor: pointer;
        transition: background 0.2s;
        display: flex;
        gap: 12px;
        align-items: center;
        background: white;
        margin-bottom: 1px;
    }

    .admin-user-item:hover {
        background: #F5F5F7;
    }

    .admin-user-avatar {
        width: 44px;
        height: 44px;
        border-radius: 50%;
        background: #FF3B30;
        color: white;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 16px;
        font-weight: 600;
        flex-shrink: 0;
    }

    .admin-user-avatar img {
        width: 100%;
        height: 100%;
        border-radius: 50%;
        object-fit: cover;
    }

    .admin-user-info {
        flex: 1;
        min-width: 0;
    }

    .admin-user-name {
        font-weight: 600;
        font-size: 14px;
        margin-bottom: 4px;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    .admin-user-message {
        font-size: 13px;
        color: #8E8E93;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    .admin-message-count {
        background: #FF3B30;
        color: white;
        border-radius: 12px;
        padding: 4px 8px;
        font-size: 11px;
        font-weight: 600;
        flex-shrink: 0;
    }

    .admin-empty-state {
        flex: 1;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        padding: 40px 20px;
        color: #8E8E93;
    }

    .admin-empty-state svg {
        width: 60px;
        height: 60px;
        margin-bottom: 16px;
        opacity: 0.5;
    }

    .admin-view-all-btn {
        padding: 12px 20px;
        background: linear-gradient(135deg, #FF3B30 0%, #D32F2F 100%);
        color: white;
        text-align: center;
        text-decoration: none;
        font-weight: 600;
        font-size: 14px;
        border: none;
        cursor: pointer;
    }

    .admin-view-all-btn:hover {
        opacity: 0.9;
    }
</style>

<!-- Admin Chat Button -->
<div class="admin-chat-btn" onclick="toggleAdminChat()">
    <svg viewBox="0 0 24 24">
        <path d="M20 2H4c-1.1 0-2 .9-2 2v18l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 14H6l-2 2V4h16v12z" />
    </svg>
    <?php if ($total_pending > 0): ?>
        <div class="admin-chat-badge"><?php echo min($total_pending, 99); ?></div>
    <?php endif; ?>
</div>

<!-- Admin Chat Panel -->
<div class="admin-chat-panel" id="adminChatPanel">
    <div class="admin-chat-header">
        <div>
            <h3>💬 User Messages</h3>
            <p style="font-size: 12px; opacity: 0.9; margin: 4px 0 0 0;">
                <?php echo count($pending_chats); ?> conversations
            </p>
        </div>
        <button class="admin-chat-close" onclick="toggleAdminChat()">
            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <path d="M18 6L6 18M6 6l12 12" />
            </svg>
        </button>
    </div>

    <div class="admin-users-list">
        <?php if (count($pending_chats) > 0): ?>
            <?php foreach ($pending_chats as $chat): ?>
                <div class="admin-user-item" onclick="openUserChat(<?php echo $chat['id']; ?>)">
                    <div class="admin-user-avatar">
                        <?php if ($chat['profile_picture'] && file_exists('../' . $chat['profile_picture'])): ?>
                            <img src="../<?php echo $chat['profile_picture']; ?>" alt="">
                        <?php else: ?>
                            <?php echo strtoupper(substr($chat['name'], 0, 1)); ?>
                        <?php endif; ?>
                    </div>
                    <div class="admin-user-info">
                        <div class="admin-user-name"><?php echo htmlspecialchars($chat['name']); ?></div>
                        <div class="admin-user-message">
                            <?php echo htmlspecialchars(substr($chat['last_message'], 0, 40)) . (strlen($chat['last_message']) > 40 ? '...' : ''); ?>
                        </div>
                    </div>
                    <?php if ($chat['message_count'] > 0): ?>
                        <span class="admin-message-count"><?php echo $chat['message_count']; ?></span>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="admin-empty-state">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z" />
                </svg>
                <h4 style="margin: 0 0 8px 0;">No Messages Yet</h4>
                <p style="font-size: 13px; margin: 0;">User messages will appear here</p>
            </div>
        <?php endif; ?>
    </div>

    <?php if (count($pending_chats) > 0): ?>
        <a href="user_chats.php" class="admin-view-all-btn">
            View All Conversations →
        </a>
    <?php endif; ?>
</div>

<script>
    function toggleAdminChat() {
        const panel = document.getElementById('adminChatPanel');
        panel.classList.toggle('active');
    }

    function openUserChat(userId) {
        window.location.href = 'user_chats.php?user_id=' + userId;
    }

    // Auto-refresh badge every 30 seconds
    setInterval(() => {
        fetch('user_chats.php')
            .then(() => {
                // Reload badge count
                location.reload();
            })
            .catch(() => { });
    }, 30000);
</script>