-- Aadhaar Data Table
CREATE TABLE IF NOT EXISTS aadhaar_data (
    id INT AUTO_INCREMENT PRIMARY KEY,
    aadhaar_number VARCHAR(12) UNIQUE NOT NULL,
    data JSON NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_aadhaar (aadhaar_number)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Sample data (optional)
INSERT INTO aadhaar_data (aadhaar_number, data) VALUES
('123456789012', '{"name": "Rajesh Kumar", "dob": "1990-05-15", "gender": "Male", "address": "123 MG Road, Bangalore", "photo": ""}'),
('234567890123', '{"name": "Priya Sharma", "dob": "1995-08-20", "gender": "Female", "address": "456 Park Street, Mumbai", "photo": ""}'),
('345678901234', '{"name": "Amit Patel", "dob": "1988-12-10", "gender": "Male", "address": "789 Gandhi Nagar, Delhi", "photo": ""}')
ON DUPLICATE KEY UPDATE data=data;
