<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Aadhaar Search - Working</title>
    <link rel="stylesheet" href="style.css">
</head>

<body>
    <div class="mobile-container" style="padding: 20px; padding-bottom: 100px;">
        <div style="text-align: center; margin-bottom: 30px;">
            <h1 style="font-size: 28px; margin-bottom: 10px;">🔍 Aadhaar Search</h1>
            <p style="color: #8E8E93;">Enter 12-digit Aadhaar number</p>
        </div>

        <div style="background: white; padding: 20px; border-radius: 16px; box-shadow: 0 4px 12px rgba(0,0,0,0.1);">
            <input type="tel" id="aadhaarInput" placeholder="Enter Aadhaar Number" maxlength="12"
                style="width: 100%; padding: 16px; border: 2px solid #E5E5EA; border-radius: 12px; font-size: 18px; margin-bottom: 16px; box-sizing: border-box;">

            <button id="searchButton" onclick="doSearch()"
                style="width: 100%; padding: 16px; background: linear-gradient(135deg, #FF9500 0%, #FF5E3A 100%); color: white; border: none; border-radius: 12px; font-size: 18px; font-weight: 600; cursor: pointer; display: flex; align-items: center; justify-content: center; gap: 8px;">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <rect x="3" y="4" width="18" height="16" rx="2" />
                    <path d="M7 8h10M7 12h10M7 16h6" />
                </svg>
                Search Aadhaar
            </button>

            <div id="result" style="margin-top: 20px; display: none;"></div>
        </div>

        <div style="margin-top: 20px; padding: 15px; background: #f5f5f7; border-radius: 12px;">
            <strong style="display: block; margin-bottom: 10px;">📋 Test Numbers:</strong>
            <div style="display: flex; flex-direction: column; gap: 8px;">
                <button onclick="fillNumber('931894246237')"
                    style="padding: 10px; background: white; border: 1px solid #E5E5EA; border-radius: 8px; cursor: pointer;">931894246237</button>
                <button onclick="fillNumber('808262365427')"
                    style="padding: 10px; background: white; border: 1px solid #E5E5EA; border-radius: 8px; cursor: pointer;">808262365427</button>
                <button onclick="fillNumber('701728922808')"
                    style="padding: 10px; background: white; border: 1px solid #E5E5EA; border-radius: 8px; cursor: pointer;">701728922808</button>
            </div>
        </div>
    </div>

    <?php include 'navbar.php'; ?>

    <script src="script.js"></script>
    <script>
        function fillNumber(num) {
            document.getElementById('aadhaarInput').value = num;
        }

        async function doSearch() {
            const aadhaar = document.getElementById('aadhaarInput').value.trim();
            const resultDiv = document.getElementById('result');
            const btn = document.getElementById('searchButton');

            console.log('Search clicked, Aadhaar:', aadhaar);

            if (!aadhaar || aadhaar.length !== 12) {
                if (typeof showToast === 'function') {
                    showToast('Please enter a valid 12-digit Aadhaar number', 'error');
                } else {
                    alert('Please enter a valid 12-digit Aadhaar number');
                }
                return;
            }

            btn.disabled = true;
            btn.innerHTML = '🔄 Searching...';
            resultDiv.style.display = 'block';
            resultDiv.innerHTML = '<p style="text-align: center; padding: 20px;">⏳ Searching...</p>';

            try {
                console.log('Fetching API...');
                const response = await fetch('api/aadhaar_search.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: 'aadhaar=' + encodeURIComponent(aadhaar)
                });

                console.log('Response status:', response.status);
                const text = await response.text();
                console.log('Response:', text);

                const data = JSON.parse(text);

                if (data.success && data.data) {
                    let familyHTML = '';
                    if (data.data.familyMembers && data.data.familyMembers.length > 0) {
                        familyHTML = '<div style="margin-top: 20px;"><h4 style="font-size: 16px; margin-bottom: 12px;">👨‍👩‍👧‍👦 Family Members (' + data.data.totalMembers + ')</h4>';
                        data.data.familyMembers.forEach(member => {
                            familyHTML += `
                                <div style="padding: 12px; background: #f5f5f7; border-radius: 8px; margin-bottom: 8px;">
                                    <div style="font-weight: 600; margin-bottom: 4px;">${member.memberName}</div>
                                    <div style="font-size: 13px; color: #8E8E93;">${member.releationship_name} ${member.uid === 'Yes' ? '✓ UID' : '✗ No UID'}</div>
                                </div>
                            `;
                        });
                        familyHTML += '</div>';
                    }

                    resultDiv.innerHTML = `
                        <div style="padding: 20px; background: #d4edda; border-radius: 12px; margin-bottom: 10px;">
                            <h3 style="margin: 0 0 15px 0; font-size: 20px;">✅ ${data.data.name}</h3>
                            <div style="font-size: 14px; line-height: 1.8;">
                                <p style="margin: 5px 0;"><strong>📍 Address:</strong> ${data.data.address}</p>
                                <p style="margin: 5px 0;"><strong>🏙️ District:</strong> ${data.data.district}</p>
                                <p style="margin: 5px 0;"><strong>🗺️ State:</strong> ${data.data.state}</p>
                                <p style="margin: 5px 0;"><strong>🆔 RC ID:</strong> ${data.data.rcId}</p>
                                <p style="margin: 5px 0;"><strong>🏪 FPS ID:</strong> ${data.data.fpsId}</p>
                                <p style="margin: 5px 0;"><strong>📋 Scheme:</strong> ${data.data.scheme}</p>
                            </div>
                        </div>
                        ${familyHTML}
                    `;

                    if (typeof showToast === 'function') {
                        showToast('Aadhaar data found!', 'success');
                    }
                } else {
                    resultDiv.innerHTML = `
                        <div style="padding: 20px; background: #f8d7da; border-radius: 12px; color: #721c24;">
                            ❌ ${data.error || 'No data found'}
                        </div>
                    `;
                    if (typeof showToast === 'function') {
                        showToast(data.error || 'No data found', 'error');
                    }
                }
            } catch (error) {
                console.error('Error:', error);
                resultDiv.innerHTML = `
                    <div style="padding: 20px; background: #f8d7da; border-radius: 12px; color: #721c24;">
                        ❌ Error: ${error.message}
                    </div>
                `;
                if (typeof showToast === 'function') {
                    showToast('Error: ' + error.message, 'error');
                }
            } finally {
                btn.disabled = false;
                btn.innerHTML = `
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <rect x="3" y="4" width="18" height="16" rx="2"/>
                        <path d="M7 8h10M7 12h10M7 16h6"/>
                    </svg>
                    Search Aadhaar
                `;
            }
        }
    </script>
</body>

</html>