<?php
require_once __DIR__ . '/../includes/auth.php';

requireUser();

if (!hasNavPermission('search')) {
    header('Location: /app/user/dashboard.php');
    exit;
}

$user = getCurrentUser();
$permissions = getUserNavPermissions();

// Get search type permissions
$canSearchMobile = (bool) ($user['can_search_mobile'] ?? 1);
$canSearchRation = (bool) ($user['can_search_ration'] ?? 1);

// Get search stats
$conn = getDBConnection();
$userId = (int) $_SESSION['user_id'];
$today = date('Y-m-d');

$sql = "SELECT COUNT(*) as count FROM search_logs 
        WHERE user_id = $userId AND DATE(search_date) = '$today'";
$result = $conn->query($sql);
$searchesToday = 0;
if ($result && $result->num_rows > 0) {
    $searchesToday = (int) $result->fetch_assoc()['count'];
}
$conn->close();

$dailyLimit = $user['daily_limit'];
$remaining = max(0, $dailyLimit - $searchesToday);
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="theme-color" content="#FFFFFF">
    <title>Search - Gravity</title>
    <link rel="stylesheet" href="/app/assets/css/style.css">
    <link rel="stylesheet" href="/app/assets/css/user.css">
</head>

<body>
    <div class="user-container">
        <header class="app-header">
            <div class="welcome-section">
                <span class="welcome-label">Number Lookup</span>
                <h1 class="welcome-name">Search</h1>
            </div>
            <div id="remaining-badge" class="badge badge-api" style="border-radius: 12px; font-size: 12px;">
                <?php echo $remaining; ?> searches left
            </div>
        </header>

        <main class="app-main search-container" style="position: relative; z-index: 1;">
            <?php if ($canSearchMobile && $canSearchRation): ?>
                <!-- Premium Search Type Selector -->
                <div style="margin-bottom: 20px;">
                    <label
                        style="display: block; margin-bottom: 8px; font-size: 13px; font-weight: 600; color: var(--text-secondary); text-transform: uppercase; letter-spacing: 0.5px;">Select
                        Service</label>

                    <div class="custom-select-wrapper" style="position: relative;">
                        <select id="searchType" class="premium-select">
                            <option value="mobile">📱 Mobile Number Search</option>
                            <option value="ration">🎫 Ration Card Search (Aadhaar)</option>
                        </select>
                        <div class="select-arrow">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round">
                                <polyline points="6 9 12 15 18 9"></polyline>
                            </svg>
                        </div>
                    </div>
                </div>

                <style>
                    .premium-select {
                        width: 100%;
                        padding: 16px 48px 16px 20px;
                        border: 2px solid var(--border-color);
                        border-radius: 16px;
                        font-size: 16px;
                        font-weight: 600;
                        background: linear-gradient(135deg, var(--bg-primary) 0%, var(--bg-secondary) 100%);
                        color: var(--text-primary);
                        cursor: pointer;
                        appearance: none;
                        -webkit-appearance: none;
                        -moz-appearance: none;
                        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
                        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.04);
                    }

                    .premium-select:hover {
                        border-color: #007AFF;
                        box-shadow: 0 4px 16px rgba(0, 122, 255, 0.15);
                        transform: translateY(-1px);
                    }

                    .premium-select:focus {
                        outline: none;
                        border-color: #007AFF;
                        box-shadow: 0 0 0 4px rgba(0, 122, 255, 0.1), 0 4px 16px rgba(0, 122, 255, 0.2);
                        transform: translateY(-1px);
                    }

                    .premium-select option {
                        padding: 12px;
                        font-size: 15px;
                        background: var(--bg-primary);
                        color: var(--text-primary);
                    }

                    .custom-select-wrapper {
                        position: relative;
                    }

                    .select-arrow {
                        position: absolute;
                        right: 16px;
                        top: 50%;
                        transform: translateY(-50%);
                        pointer-events: none;
                        color: #007AFF;
                        transition: transform 0.3s ease;
                    }

                    .premium-select:focus+.select-arrow {
                        transform: translateY(-50%) rotate(180deg);
                    }

                    @media (max-width: 768px) {
                        .premium-select {
                            font-size: 15px;
                            padding: 14px 44px 14px 18px;
                        }
                    }
                </style>

                <!-- Search Input Field -->
                <form id="searchForm" class="search-field-wrapper">
                    <div class="search-icon-float">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                            stroke-linecap="round" stroke-linejoin="round">
                            <circle cx="11" cy="11" r="8"></circle>
                            <line x1="21" y1="21" x2="16.65" y2="16.65"></line>
                        </svg>
                    </div>
                    <input type="tel" id="searchInput" class="search-input-premium" placeholder="Enter mobile number..."
                        required maxlength="10" pattern="[0-9]{10}">
                    <button type="submit" id="searchBtn" style="display: none;"></button>
                </form>

            <?php elseif ($canSearchMobile): ?>
                <!-- Only Mobile Search -->
                <input type="hidden" id="searchType" value="mobile">
                <div
                    style="margin-bottom: 16px; padding: 12px 16px; background: rgba(0, 122, 255, 0.1); border-radius: 12px; color: #007AFF; font-weight: 600;">
                    📱 Mobile Number Search
                </div>

                <!-- Search Input Field -->
                <form id="searchForm" class="search-field-wrapper">
                    <div class="search-icon-float">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                            stroke-linecap="round" stroke-linejoin="round">
                            <circle cx="11" cy="11" r="8"></circle>
                            <line x1="21" y1="21" x2="16.65" y2="16.65"></line>
                        </svg>
                    </div>
                    <input type="tel" id="searchInput" class="search-input-premium" placeholder="Enter mobile number..."
                        required maxlength="10" pattern="[0-9]{10}">
                    <button type="submit" id="searchBtn" style="display: none;"></button>
                </form>

            <?php elseif ($canSearchRation): ?>
                <!-- Only Ration Card Search -->
                <input type="hidden" id="searchType" value="ration">
                <div
                    style="margin-bottom: 16px; padding: 12px 16px; background: rgba(118, 75, 162, 0.1); border-radius: 12px; color: #764ba2; font-weight: 600;">
                    🎫 Ration Card Search (Aadhaar)
                </div>

                <!-- Search Input Field -->
                <form id="searchForm" class="search-field-wrapper">
                    <div class="search-icon-float">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                            stroke-linecap="round" stroke-linejoin="round">
                            <circle cx="11" cy="11" r="8"></circle>
                            <line x1="21" y1="21" x2="16.65" y2="16.65"></line>
                        </svg>
                    </div>
                    <input type="tel" id="searchInput" class="search-input-premium" placeholder="Enter Aadhaar number..."
                        required maxlength="12" pattern="[0-9]{12}">
                    <button type="submit" id="searchBtn" style="display: none;"></button>
                </form>

            <?php else: ?>
                <!-- No search permission -->
                <div style="padding: 40px; text-align: center;">
                    <div style="font-size: 48px; margin-bottom: 16px;">🔒</div>
                    <h3 style="color: var(--text-primary); margin-bottom: 8px;">No Search Access</h3>
                    <p style="color: var(--text-secondary);">You don't have permission to use any search features.</p>
                </div>
            <?php endif; ?>

            <?php if ($canSearchMobile || $canSearchRation): ?>

                <div id="searchResult" style="display: none;">
                    <!-- Result will be populated by JS -->
                </div>

                <div id="loading" class="loading-container" style="display: none; padding: 40px; text-align: center;">
                    <div class="spinner" style="margin: 0 auto 16px;"></div>
                    <p style="color: var(--text-tertiary); font-weight: 600;">Searching database & API...</p>
                </div>

                <div id="error" class="alert alert-warning" style="display: none;">
                    <div class="alert-icon">⚠️</div>
                    <p id="errorMessage"></p>
                </div>

            <?php endif; ?>
        </main>

        <?php include __DIR__ . '/../includes/user-nav.php'; ?>
    </div>

    <!-- Toast Notification -->
    <div id="toast" class="toast"></div>

    <script src="/app/assets/js/search.js" defer></script>
    <script src="/app/assets/js/ration-search.js" defer></script>
    <script>
        // Auto-submit on complete input
        document.addEventListener('DOMContentLoaded', function () {
            const searchInputEl = document.getElementById('searchInput');
            if (searchInputEl) {
                searchInputEl.addEventListener('input', function (e) {
                    const searchType = document.getElementById('searchType').value;
                    const maxLength = searchType === 'mobile' ? 10 : 12;

                    if (this.value.length === maxLength) {
                        document.getElementById('searchForm').dispatchEvent(new Event('submit'));
                    }
                });
            }
        });
    </script>
</body>

</html>