<?php
require_once __DIR__ . '/../includes/auth.php';

requireUser();

if (!hasNavPermission('history')) {
    header('Location: /app/user/dashboard.php');
    exit;
}

$user = getCurrentUser();
$permissions = getUserNavPermissions();

$conn = getDBConnection();
$userId = (int) $_SESSION['user_id'];

// Get search history
$sql = "SELECT mobile_number, source, search_date, search_type 
        FROM search_logs 
        WHERE user_id = $userId 
        ORDER BY search_date DESC";
$result = $conn->query($sql);
$history = [];
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $history[] = $row;
    }
}
$conn->close();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="theme-color" content="#FFFFFF">
    <title>History - Gravity</title>
    <link rel="stylesheet" href="/app/assets/css/style.css">
    <link rel="stylesheet" href="/app/assets/css/user.css">
</head>

<body>
    <div class="user-container">
        <header class="app-header">
            <div class="welcome-section">
                <span class="welcome-label">Your Activity</span>
                <h1 class="welcome-name">History</h1>
            </div>
            <div class="profile-thumb">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                    stroke-linecap="round" stroke-linejoin="round">
                    <path d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
            </div>
        </header>

        <main class="app-main" style="position: relative; z-index: 1;">
            <!-- Filter Tabs -->
            <div style="margin-bottom: 20px; display: flex; gap: 8px; overflow-x: auto; padding-bottom: 8px;">
                <button class="filter-btn active" data-filter="all"
                    style="padding: 10px 20px; border: 2px solid var(--border-color); border-radius: 12px; background: var(--bg-primary); color: var(--text-primary); font-weight: 600; cursor: pointer; white-space: nowrap; transition: all 0.2s;">
                    All Searches
                </button>
                <button class="filter-btn" data-filter="mobile"
                    style="padding: 10px 20px; border: 2px solid var(--border-color); border-radius: 12px; background: var(--bg-primary); color: var(--text-primary); font-weight: 600; cursor: pointer; white-space: nowrap; transition: all 0.2s;">
                    📱 Mobile
                </button>
                <button class="filter-btn" data-filter="ration_card"
                    style="padding: 10px 20px; border: 2px solid var(--border-color); border-radius: 12px; background: var(--bg-primary); color: var(--text-primary); font-weight: 600; cursor: pointer; white-space: nowrap; transition: all 0.2s;">
                    🎫 Ration Card
                </button>
            </div>

            <!-- Search Bar -->
            <div class="search-field-wrapper" style="margin-bottom: 20px;">
                <div class="search-icon-float">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                        stroke-linecap="round" stroke-linejoin="round">
                        <circle cx="11" cy="11" r="8"></circle>
                        <line x1="21" y1="21" x2="16.65" y2="16.65"></line>
                    </svg>
                </div>
                <input type="tel" id="historySearch" class="search-input-premium"
                    style="padding: 14px 14px 14px 48px; border-radius: 16px; font-size: 15px;"
                    placeholder="Search in history...">
            </div>

            <div class="section">
                <div class="recent-list" id="historyList">
                    <?php if (empty($history)): ?>
                        <div class="empty-state">
                            <div class="empty-icon">📂</div>
                            <p>No search history found.</p>
                            <p class="empty-sub">Your previous searches will appear here.</p>
                        </div>
                    <?php else: ?>
                        <?php foreach ($history as $search):
                            $searchType = $search['search_type'] ?? 'mobile';
                            $icon = $searchType === 'ration_card' ? '🎫' : '📱';
                            $iconColor = $searchType === 'ration_card' ? '#764ba2' : '#007AFF';
                            ?>
                            <div class="activity-item history-item"
                                data-number="<?php echo htmlspecialchars($search['mobile_number']); ?>"
                                data-type="<?php echo htmlspecialchars($searchType); ?>">
                                <div class="activity-icon"
                                    style="background: rgba(<?php echo $searchType === 'ration_card' ? '118, 75, 162' : '0, 122, 255'; ?>, 0.1);">
                                    <span style="font-size: 20px;"><?php echo $icon; ?></span>
                                </div>
                                <div class="activity-content">
                                    <div class="activity-title"><?php echo htmlspecialchars($search['mobile_number']); ?></div>
                                    <div class="activity-meta">
                                        <span
                                            class="activity-date"><?php echo date('M d, Y h:i A', strtotime($search['search_date'])); ?></span>
                                        <span class="dot"></span>
                                        <span class="activity-source"><?php echo $search['source']; ?></span>
                                        <span class="dot"></span>
                                        <span style="color: <?php echo $iconColor; ?>; font-weight: 600;">
                                            <?php echo $searchType === 'ration_card' ? 'Ration Card' : 'Mobile'; ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        </main>

        <?php include __DIR__ . '/../includes/user-nav.php'; ?>
    </div>

    <script>
        // Filter functionality
        const filterBtns = document.querySelectorAll('.filter-btn');
        const historyItems = document.querySelectorAll('.history-item');

        filterBtns.forEach(btn => {
            btn.addEventListener('click', () => {
                // Update active state
                filterBtns.forEach(b => {
                    b.classList.remove('active');
                    b.style.background = 'var(--bg-primary)';
                    b.style.borderColor = 'var(--border-color)';
                });
                btn.classList.add('active');
                btn.style.background = 'rgba(0, 122, 255, 0.1)';
                btn.style.borderColor = '#007AFF';

                const filter = btn.getAttribute('data-filter');

                // Filter items
                historyItems.forEach(item => {
                    const itemType = item.getAttribute('data-type');

                    if (filter === 'all') {
                        item.style.display = 'flex';
                    } else if (itemType === filter) {
                        item.style.display = 'flex';
                    } else {
                        item.style.display = 'none';
                    }
                });
            });
        });

        // Search functionality
        document.getElementById('historySearch').addEventListener('input', function (e) {
            const term = e.target.value.toLowerCase();
            const items = document.querySelectorAll('.history-item');

            items.forEach(item => {
                const number = item.getAttribute('data-number').toLowerCase();
                const currentDisplay = item.style.display;

                // Only search in visible items (respecting filter)
                if (currentDisplay !== 'none') {
                    if (number.includes(term)) {
                        item.style.display = 'flex';
                    } else {
                        item.style.display = 'none';
                    }
                }
            });
        });
    </script>
</body>

</html>