<?php
require_once __DIR__ . '/../includes/auth.php';

requireUser();

if (!hasNavPermission('dashboard')) {
    header('Location: /app/user/search.php');
    exit;
}

$user = getCurrentUser();
$permissions = getUserNavPermissions();

// Get today's search count
$conn = getDBConnection();
$userId = (int) $_SESSION['user_id'];
$today = date('Y-m-d');

$sql = "SELECT COUNT(*) as count FROM search_logs 
        WHERE user_id = $userId AND DATE(search_date) = '$today'";
$result = $conn->query($sql);
$searchesToday = 0;
if ($result && $result->num_rows > 0) {
    $searchesToday = (int) $result->fetch_assoc()['count'];
}

// Get recent searches
$recentSql = "SELECT mobile_number, source, search_date 
              FROM search_logs 
              WHERE user_id = $userId 
              ORDER BY search_date DESC 
              LIMIT 5";
$recentResult = $conn->query($recentSql);
$recentSearches = [];
if ($recentResult) {
    while ($row = $recentResult->fetch_assoc()) {
        $recentSearches[] = $row;
    }
}

// Don't close connection yet - we need it for login logs below

$dailyLimit = $user['daily_limit'];
$searchesRemaining = max(0, $dailyLimit - $searchesToday);
$progressPercent = ($dailyLimit > 0) ? min(100, ($searchesToday / $dailyLimit) * 100) : 0;
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="theme-color" content="#FFFFFF">
    <title>Dashboard - Gravity</title>
    <link rel="stylesheet" href="/app/assets/css/style.css">
    <link rel="stylesheet" href="/app/assets/css/user.css">
</head>

<body>
    <div class="user-container">
        <!-- App Header -->
        <header class="app-header">
            <div class="welcome-section">
                <span class="welcome-label">Hello,</span>
                <h1 class="welcome-name"><?php echo htmlspecialchars($user['name']); ?></h1>
            </div>
            <div class="profile-thumb">
                <?php echo strtoupper(substr($user['name'], 0, 1)); ?>
            </div>
        </header>


        <!-- GRAVITY Watermark - Responsive -->
        <style>
            .gravity-watermark {
                position: fixed;
                top: 50%;
                left: 50%;
                transform: translate(-50%, -50%) rotate(-45deg);
                font-size: 120px;
                font-weight: 900;
                color: rgba(0, 0, 0, 0.03);
                letter-spacing: 20px;
                z-index: 0;
                pointer-events: none;
                user-select: none;
                font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', 'Roboto', sans-serif;
                white-space: nowrap;
            }

            @media (max-width: 768px) {
                .gravity-watermark {
                    font-size: 60px;
                    letter-spacing: 10px;
                }
            }

            @media (max-width: 480px) {
                .gravity-watermark {
                    font-size: 40px;
                    letter-spacing: 5px;
                }
            }
        </style>
        <div class="gravity-watermark">GRAVITY</div>

        <main class="app-main" style="position: relative; z-index: 1;">
            <!-- Search Stats Card -->
            <div class="stats-card">
                <div class="stats-header">
                    <h3 class="stats-title">Daily Search Status</h3>
                    <span class="stats-percentage"><?php echo $searchesRemaining; ?> left</span>
                </div>
                <div class="search-progress-container">
                    <div class="search-progress-bar" style="width: <?php echo $progressPercent; ?>%"></div>
                </div>
                <div class="stats-footer">
                    <div class="stat-detail">
                        <span class="stat-count"><?php echo $searchesToday; ?></span>
                        <span class="stat-text">Today</span>
                    </div>
                    <div class="stat-divider"></div>
                    <div class="stat-detail">
                        <span class="stat-count"><?php echo $dailyLimit; ?></span>
                        <span class="stat-text">Limit</span>
                    </div>
                </div>
            </div>

            <!-- Quick Action -->
            <div class="quick-action">
                <a href="/app/user/search.php" class="btn-search-app">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5"
                        stroke-linecap="round" stroke-linejoin="round">
                        <circle cx="11" cy="11" r="8"></circle>
                        <line x1="21" y1="21" x2="16.65" y2="16.65"></line>
                    </svg>
                    Start New Search
                </a>
            </div>

            <!-- Recent Login Activity -->
            <div class="section">
                <div class="section-header">
                    <h2 class="section-title">Recent Login Activity</h2>
                </div>

                <div class="recent-list">
                    <?php
                    // Get recent logins (will work after SQL table is created)
                    $loginSql = "SELECT * FROM login_logs WHERE user_id = $userId ORDER BY login_time DESC LIMIT 5";
                    $loginResult = $conn->query($loginSql);

                    if ($loginResult && $loginResult->num_rows > 0):
                        while ($login = $loginResult->fetch_assoc()):
                            // Detect device/OS from user agent
                            $userAgent = $login['user_agent'];
                            $device = 'Unknown Device';

                            if (stripos($userAgent, 'Windows') !== false) {
                                $device = 'Windows';
                            } elseif (stripos($userAgent, 'Mac') !== false || stripos($userAgent, 'iPhone') !== false || stripos($userAgent, 'iPad') !== false) {
                                if (stripos($userAgent, 'iPhone') !== false) {
                                    $device = 'iPhone';
                                } elseif (stripos($userAgent, 'iPad') !== false) {
                                    $device = 'iPad';
                                } else {
                                    $device = 'Mac';
                                }
                            } elseif (stripos($userAgent, 'Android') !== false) {
                                $device = 'Android';
                            } elseif (stripos($userAgent, 'Linux') !== false) {
                                $device = 'Linux';
                            }

                            // Get browser
                            $browser = '';
                            if (stripos($userAgent, 'Chrome') !== false && stripos($userAgent, 'Edg') === false) {
                                $browser = 'Chrome';
                            } elseif (stripos($userAgent, 'Firefox') !== false) {
                                $browser = 'Firefox';
                            } elseif (stripos($userAgent, 'Safari') !== false && stripos($userAgent, 'Chrome') === false) {
                                $browser = 'Safari';
                            } elseif (stripos($userAgent, 'Edg') !== false) {
                                $browser = 'Edge';
                            }

                            $deviceName = $device . ($browser ? " · $browser" : '');
                            ?>
                            <div class="activity-item">
                                <div class="activity-icon" style="background: rgba(52, 199, 89, 0.1);">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#34C759"
                                        stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect>
                                        <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
                                    </svg>
                                </div>
                                <div class="activity-content">
                                    <div class="activity-title"><?php echo htmlspecialchars($deviceName); ?></div>
                                    <div class="activity-meta">
                                        <span
                                            class="activity-date"><?php echo date('M d, Y h:i A', strtotime($login['login_time'])); ?></span>
                                        <span class="dot"></span>
                                        <span
                                            style="font-size: 11px; opacity: 0.7;"><?php echo htmlspecialchars(substr($login['ip_address'], 0, 15)); ?></span>
                                    </div>
                                </div>
                            </div>
                            <?php
                        endwhile;
                    else:
                        ?>
                        <div class="empty-state">
                            <div class="empty-icon">🔐</div>
                            <p>No login history yet.</p>
                            <p class="empty-sub">Login activity will appear here.</p>
                        </div>
                        <?php
                    endif;
                    $conn->close(); // Close connection after all queries
                    ?>
                </div>
            </div>
        </main>

        <?php include __DIR__ . '/../includes/user-nav.php'; ?>
    </div>
</body>

</html>