<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="theme-color" content="#FFFFFF">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <title>Register - Gravity</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>

<body>
    <div class="auth-container">
        <div class="auth-card">
            <div class="auth-header">
                <div class="app-icon">
                    <svg width="60" height="60" viewBox="0 0 60 60" fill="none">
                        <rect width="60" height="60" rx="15" fill="#007AFF" />
                        <path
                            d="M30 15C21.7 15 15 21.7 15 30C15 38.3 21.7 45 30 45C38.3 45 45 38.3 45 30C45 21.7 38.3 15 30 15ZM30 27C31.7 27 33 28.3 33 30C33 31.7 31.7 33 30 33C28.3 33 27 31.7 27 30C27 28.3 28.3 27 30 27Z"
                            fill="white" />
                    </svg>
                </div>
                <h1 class="app-title">Create Account</h1>
                <p class="app-subtitle">Join Gravity</p>
                <a href="index.html"
                    style="display: inline-block; margin-top: 10px; color: #007AFF; text-decoration: none; font-size: 14px; font-weight: 500;">
                    ← Back to Home
                </a>
            </div>

            <form id="registerForm" class="auth-form">
                <div class="form-group">
                    <label for="name">Full Name</label>
                    <input type="text" id="name" name="name" placeholder="Enter your name" required>
                </div>

                <div class="form-group">
                    <label for="mobile">Mobile Number</label>
                    <input type="tel" id="mobile" name="mobile" placeholder="Enter your mobile number" required>
                </div>

                <div class="form-group">
                    <label for="email">Email</label>
                    <input type="email" id="email" name="email" placeholder="Enter your email" required>
                </div>

                <div class="form-group">
                    <label for="password">Password</label>
                    <div style="position: relative;">
                        <input type="password" id="password" name="password" placeholder="Create a password" required
                            style="padding-right: 45px;">
                        <button type="button" onclick="togglePassword('password', 'eyeIcon1')"
                            style="position: absolute; right: 12px; top: 50%; transform: translateY(-50%); background: none; border: none; cursor: pointer; padding: 8px; color: var(--text-tertiary); transition: color 0.2s;">
                            <svg id="eyeIcon1" width="20" height="20" viewBox="0 0 24 24" fill="none"
                                stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path>
                                <circle cx="12" cy="12" r="3"></circle>
                            </svg>
                        </button>
                    </div>
                </div>

                <div class="form-group">
                    <label for="confirmPassword">Confirm Password</label>
                    <div style="position: relative;">
                        <input type="password" id="confirmPassword" name="confirmPassword"
                            placeholder="Confirm your password" required style="padding-right: 45px;">
                        <button type="button" onclick="togglePassword('confirmPassword', 'eyeIcon2')"
                            style="position: absolute; right: 12px; top: 50%; transform: translateY(-50%); background: none; border: none; cursor: pointer; padding: 8px; color: var(--text-tertiary); transition: color 0.2s;">
                            <svg id="eyeIcon2" width="20" height="20" viewBox="0 0 24 24" fill="none"
                                stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path>
                                <circle cx="12" cy="12" r="3"></circle>
                            </svg>
                        </button>
                    </div>
                </div>

                <div class="form-group">
                    <label for="referralCode">Referral ID (Optional)</label>
                    <input type="text" id="referralCode" name="referralCode"
                        placeholder="Enter referral ID if you have one" style="text-transform: uppercase;">
                    <small style="font-size: 12px; color: var(--text-tertiary); margin-top: 4px; display: block;">Get 20
                        searches with ID (10 without ID)</small>
                </div>

                <!-- CAPTCHA -->
                <div class="form-group">
                    <label for="captcha">Security Check</label>
                    <div style="display: flex; align-items: center; gap: 12px; margin-bottom: 8px;">
                        <div id="captchaQuestion"
                            style="background: var(--bg-secondary); padding: 12px 16px; border-radius: 8px; font-weight: 700; font-size: 16px; color: var(--text-primary); flex: 1; text-align: center;">
                        </div>
                        <button type="button" onclick="generateCaptcha()"
                            style="background: var(--bg-secondary); border: 1px solid var(--border-color); padding: 12px; border-radius: 8px; cursor: pointer; transition: all 0.2s;">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                stroke-width="2">
                                <path
                                    d="M21.5 2v6h-6M2.5 22v-6h6M2 11.5a10 10 0 0 1 18.8-4.3M22 12.5a10 10 0 0 1-18.8 4.2" />
                            </svg>
                        </button>
                    </div>
                    <input type="number" id="captcha" name="captcha" placeholder="Enter the answer" required
                        style="width: 100%;">
                </div>

                <button type="submit" class="btn-primary" id="registerBtn">
                    <span class="btn-text">Create Account</span>
                    <span class="btn-loader" style="display: none;">
                        <svg class="spinner" viewBox="0 0 50 50">
                            <circle class="path" cx="25" cy="25" r="20" fill="none" stroke-width="5"></circle>
                        </svg>
                    </span>
                </button>

                <div class="auth-divider">
                    <span>Already have an account?</span>
                </div>

                <a href="login.php" class="btn-secondary">Sign In</a>
            </form>
        </div>
    </div>

    <div id="toast" class="toast"></div>

    <script>
        const registerForm = document.getElementById('registerForm');
        const registerBtn = document.getElementById('registerBtn');
        const btnText = registerBtn.querySelector('.btn-text');
        const btnLoader = registerBtn.querySelector('.btn-loader');

        // CAPTCHA variables
        let captchaAnswer = 0;

        // Generate CAPTCHA
        function generateCaptcha() {
            const num1 = Math.floor(Math.random() * 20) + 1;
            const num2 = Math.floor(Math.random() * 20) + 1;
            const operators = ['+', '-', '×'];
            const operator = operators[Math.floor(Math.random() * operators.length)];

            let question = `${num1} ${operator} ${num2} = ?`;

            // Calculate answer
            switch (operator) {
                case '+':
                    captchaAnswer = num1 + num2;
                    break;
                case '-':
                    captchaAnswer = num1 - num2;
                    break;
                case '×':
                    captchaAnswer = num1 * num2;
                    break;
            }

            document.getElementById('captchaQuestion').textContent = question;
            document.getElementById('captcha').value = '';
        }

        // Generate CAPTCHA on page load
        generateCaptcha();

        // Auto-fill referral code from localStorage or URL
        function loadReferralCode() {
            let refCode = null;

            // Check localStorage first (from invite link)
            const storedCode = localStorage.getItem('referralCode');
            const expiry = localStorage.getItem('referralExpiry');

            if (storedCode && expiry) {
                // Check if not expired (7 days)
                if (Date.now() < parseInt(expiry)) {
                    refCode = storedCode;
                } else {
                    // Expired, clear it
                    localStorage.removeItem('referralCode');
                    localStorage.removeItem('referralExpiry');
                }
            }

            // If no localStorage code, check URL parameter
            if (!refCode) {
                const urlParams = new URLSearchParams(window.location.search);
                refCode = urlParams.get('ref');
            }

            // Fill the code if found
            if (refCode) {
                document.getElementById('referralCode').value = refCode.toUpperCase();
            }
        }

        loadReferralCode();

        registerForm.addEventListener('submit', async (e) => {
            e.preventDefault();

            const name = document.getElementById('name').value.trim();
            const mobile = document.getElementById('mobile').value.trim();
            const email = document.getElementById('email').value.trim();
            const password = document.getElementById('password').value;
            const confirmPassword = document.getElementById('confirmPassword').value;
            const referralCode = document.getElementById('referralCode').value.trim().toUpperCase();
            const userCaptcha = parseInt(document.getElementById('captcha').value);

            // Validation
            if (!name || !mobile || !email || !password || !confirmPassword) {
                showToast('Please fill in all fields', 'error');
                return;
            }

            if (password.length < 6) {
                showToast('Password must be at least 6 characters', 'error');
                return;
            }

            if (password !== confirmPassword) {
                showToast('Passwords do not match', 'error');
                return;
            }

            // Validate CAPTCHA
            if (isNaN(userCaptcha) || userCaptcha !== captchaAnswer) {
                showToast('Incorrect security answer. Please try again.', 'error');
                generateCaptcha();
                return;
            }

            // Show loading
            btnText.style.display = 'none';
            btnLoader.style.display = 'inline-block';
            registerBtn.disabled = true;

            try {
                const response = await fetch('api/register.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({ name, mobile, email, password, referral_code: referralCode })
                });

                const data = await response.json();

                if (data.success) {
                    showToast(data.message, 'success');
                    setTimeout(() => {
                        window.location.href = 'login.php';
                    }, 2000);
                } else {
                    showToast(data.message || 'Registration failed', 'error');
                    generateCaptcha();
                    btnText.style.display = 'inline-block';
                    btnLoader.style.display = 'none';
                    registerBtn.disabled = false;
                }
            } catch (error) {
                showToast('Network error. Please try again.', 'error');
                generateCaptcha();
                btnText.style.display = 'inline-block';
                btnLoader.style.display = 'none';
                registerBtn.disabled = false;
            }
        });

        function showToast(message, type = 'info') {
            const toast = document.getElementById('toast');
            toast.textContent = message;
            toast.className = `toast toast-${type} show`;

            setTimeout(() => {
                toast.classList.remove('show');
            }, 3000);
        }

        // Toggle password visibility
        function togglePassword(inputId, iconId) {
            const passwordInput = document.getElementById(inputId);
            const eyeIcon = document.getElementById(iconId);

            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                eyeIcon.innerHTML = '<path d="M17.94 17.94A10.07 10.07 0 0 1 12 20c-7 0-11-8-11-8a18.45 18.45 0 0 1 5.06-5.94M9.9 4.24A9.12 9.12 0 0 1 12 4c7 0 11 8 11 8a18.5 18.5 0 0 1-2.16 3.19m-6.72-1.07a3 3 0 1 1-4.24-4.24"></path><line x1="1" y1="1" x2="23" y2="23"></line>';
            } else {
                passwordInput.type = 'password';
                eyeIcon.innerHTML = '<path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path><circle cx="12" cy="12" r="3"></circle>';
            }
        }
    </script>
</body>

</html>