-- ========================================
-- PERFORMANCE OPTIMIZATION SQL
-- Run this on LIVE SERVER database
-- ========================================

-- Add indexes for faster queries
ALTER TABLE mobile_data ADD INDEX IF NOT EXISTS idx_mobile (mobile_number);
ALTER TABLE mobile_data ADD INDEX IF NOT EXISTS idx_created (created_at);

ALTER TABLE search_logs ADD INDEX IF NOT EXISTS idx_user_date (user_id, search_date);
ALTER TABLE search_logs ADD INDEX IF NOT EXISTS idx_mobile (mobile_number);
ALTER TABLE search_logs ADD INDEX IF NOT EXISTS idx_date (search_date);

ALTER TABLE users ADD INDEX IF NOT EXISTS idx_email (email);
ALTER TABLE users ADD INDEX IF NOT EXISTS idx_status (status);
ALTER TABLE users ADD INDEX IF NOT EXISTS idx_role (role);
ALTER TABLE users ADD INDEX IF NOT EXISTS idx_referral (referral_code);

ALTER TABLE referrals ADD INDEX IF NOT EXISTS idx_referrer (referrer_id);
ALTER TABLE referrals ADD INDEX IF NOT EXISTS idx_referee (referee_id);

ALTER TABLE api_logs ADD INDEX IF NOT EXISTS idx_mobile_time (mobile_number, request_time);
ALTER TABLE api_logs ADD INDEX IF NOT EXISTS idx_status (status_code);

ALTER TABLE login_logs ADD INDEX IF NOT EXISTS idx_user_time (user_id, login_time);

-- Optimize all tables
OPTIMIZE TABLE users;
OPTIMIZE TABLE mobile_data;
OPTIMIZE TABLE search_logs;
OPTIMIZE TABLE api_logs;
OPTIMIZE TABLE login_logs;
OPTIMIZE TABLE referrals;
OPTIMIZE TABLE settings;

-- Show index status
SHOW INDEX FROM users;
SHOW INDEX FROM mobile_data;
SHOW INDEX FROM search_logs;

-- Done!
SELECT 'Performance optimization complete! ✅' as Status;
