<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="theme-color" content="#FFFFFF">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <title>Login - Gravity</title>
    <link rel="stylesheet" href="assets/css/style.css?v=2.0">
</head>

<?php
session_start();
$logoutMessage = $_SESSION['logout_message'] ?? '';
unset($_SESSION['logout_message']);
?>

<body>
    <div class="auth-container">
        <div class="auth-card">
            <div class="auth-header">
                <div class="app-icon">
                    <svg width="60" height="60" viewBox="0 0 60 60" fill="none">
                        <rect width="60" height="60" rx="15" fill="#007AFF" />
                        <path
                            d="M30 15C21.7 15 15 21.7 15 30C15 38.3 21.7 45 30 45C38.3 45 45 38.3 45 30C45 21.7 38.3 15 30 15ZM30 27C31.7 27 33 28.3 33 30C33 31.7 31.7 33 30 33C28.3 33 27 31.7 27 30C27 28.3 28.3 27 30 27Z"
                            fill="white" />
                    </svg>
                </div>
                <h1 class="app-title">Gravity</h1>
                <p class="app-subtitle">Sign in to continue</p>
                <a href="index.html"
                    style="display: inline-block; margin-top: 10px; color: #007AFF; text-decoration: none; font-size: 14px; font-weight: 500;">
                    ← Back to Home
                </a>
            </div>

            <form id="loginForm" class="auth-form">
                <div class="form-group">
                    <label for="email">Email</label>
                    <input type="email" id="email" name="email" placeholder="Enter your email" required>
                </div>

                <div class="form-group">
                    <label for="password">Password</label>
                    <div style="position: relative;">
                        <input type="password" id="password" name="password" placeholder="Enter your password" required
                            style="padding-right: 45px;">
                        <button type="button" onclick="togglePassword()"
                            style="position: absolute; right: 12px; top: 50%; transform: translateY(-50%); background: none; border: none; cursor: pointer; padding: 8px; color: var(--text-tertiary); transition: color 0.2s;">
                            <svg id="eyeIcon" width="20" height="20" viewBox="0 0 24 24" fill="none"
                                stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path>
                                <circle cx="12" cy="12" r="3"></circle>
                            </svg>
                        </button>
                    </div>
                </div>

                <!-- CAPTCHA -->
                <div class="form-group">
                    <label for="captcha">Security Check</label>
                    <div style="display: flex; align-items: center; gap: 12px; margin-bottom: 8px;">
                        <div id="captchaQuestion"
                            style="background: var(--bg-secondary); padding: 12px 16px; border-radius: 8px; font-weight: 700; font-size: 16px; color: var(--text-primary); flex: 1; text-align: center;">
                        </div>
                        <button type="button" onclick="generateCaptcha()"
                            style="background: var(--bg-secondary); border: 1px solid var(--border-color); padding: 12px; border-radius: 8px; cursor: pointer; transition: all 0.2s;">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                stroke-width="2">
                                <path
                                    d="M21.5 2v6h-6M2.5 22v-6h6M2 11.5a10 10 0 0 1 18.8-4.3M22 12.5a10 10 0 0 1-18.8 4.2" />
                            </svg>
                        </button>
                    </div>
                    <input type="number" id="captcha" name="captcha" placeholder="Enter the answer" required
                        style="width: 100%;">
                </div>

                <button type="submit" class="btn-primary" id="loginBtn">
                    <span class="btn-text">Sign In</span>
                    <span class="btn-loader" style="display: none;">
                        <svg class="spinner" viewBox="0 0 50 50">
                            <circle class="path" cx="25" cy="25" r="20" fill="none" stroke-width="5"></circle>
                        </svg>
                    </span>
                </button>


                <a href="register.php" class="btn-secondary">Create Account</a>
            </form>


        </div>


        <div id="toast" class="toast"></div>

        <script>
            const loginForm = document.getElementById('loginForm');
            const loginBtn = document.getElementById('loginBtn');
            const btnText = loginBtn.querySelector('.btn-text');
            const btnLoader = loginBtn.querySelector('.btn-loader');

            // CAPTCHA
            let captchaAnswer = 0;

            function generateCaptcha() {
                const num1 = Math.floor(Math.random() * 10) + 1;
                const num2 = Math.floor(Math.random() * 10) + 1;
                captchaAnswer = num1 + num2;
                document.getElementById('captchaQuestion').textContent = `${num1} + ${num2} = ?`;
            }

            generateCaptcha();

            // Toggle password visibility
            function togglePassword() {
                const passwordInput = document.getElementById('password');
                const eyeIcon = document.getElementById('eyeIcon');

                if (passwordInput.type === 'password') {
                    passwordInput.type = 'text';
                    eyeIcon.innerHTML = `
                        <path d="M17.94 17.94A10.07 10.07 0 0 1 12 20c-7 0-11-8-11-8a18.45 18.45 0 0 1 5.06-5.94M9.9 4.24A9.12 9.12 0 0 1 12 4c7 0 11 8 11 8a18.5 18.5 0 0 1-2.16 3.19m-6.72-1.07a3 3 0 1 1-4.24-4.24"></path>
                        <line x1="1" y1="1" x2="23" y2="23"></line>
                    `;
                } else {
                    passwordInput.type = 'password';
                    eyeIcon.innerHTML = `
                        <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path>
                        <circle cx="12" cy="12" r="3"></circle>
                    `;
                }
            }

            // Login form submission
            loginForm.addEventListener('submit', async (e) => {
                e.preventDefault();

                const email = document.getElementById('email').value;
                const password = document.getElementById('password').value;
                const captcha = parseInt(document.getElementById('captcha').value);

                // Validate CAPTCHA
                if (captcha !== captchaAnswer) {
                    showToast('Incorrect CAPTCHA answer', 'error');
                    generateCaptcha();
                    document.getElementById('captcha').value = '';
                    return;
                }

                // Show loading
                btnText.style.display = 'none';
                btnLoader.style.display = 'inline-block';
                loginBtn.disabled = true;

                try {
                    const response = await fetch('/app/api/login.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify({ email, password })
                    });

                    const data = await response.json();

                    if (data.success) {
                        showToast('Login successful! Redirecting...', 'success');
                        setTimeout(() => {
                            if (data.role === 'admin') {
                                window.location.href = '/app/admin/dashboard.php';
                            } else {
                                window.location.href = '/app/user/dashboard.php';
                            }
                        }, 1000);
                    } else {
                        showToast(data.message || 'Login failed', 'error');
                        generateCaptcha();
                        document.getElementById('captcha').value = '';
                        btnText.style.display = 'inline-block';
                        btnLoader.style.display = 'none';
                        loginBtn.disabled = false;
                    }
                } catch (error) {
                    showToast('Network error. Please try again.', 'error');
                    generateCaptcha();
                    document.getElementById('captcha').value = '';
                    btnText.style.display = 'inline-block';
                    btnLoader.style.display = 'none';
                    loginBtn.disabled = false;
                }
            });

            function showToast(message, type = 'info') {
                const toast = document.getElementById('toast');
                toast.textContent = message;
                toast.className = `toast toast-${type} show`;

                setTimeout(() => {
                    toast.className = 'toast';
                }, 3000);
            }

            // Show logout message if present
            <?php if ($logoutMessage): ?>
                showToast('<?php echo addslashes($logoutMessage); ?>', 'success');
            <?php endif; ?>
        </script>
    </div>
</body>

</html>