<?php
// Get referral code from URL
$referralCode = isset($_GET['ref']) ? strtoupper(trim($_GET['ref'])) : '';

// Validate referral code
$isValidCode = false;
$referrerName = '';

if ($referralCode) {
    require_once __DIR__ . '/config/database.php';
    $conn = getDBConnection();
    $code = $conn->real_escape_string($referralCode);

    $sql = "SELECT name FROM users WHERE referral_code = '$code'";
    $result = $conn->query($sql);

    if ($result && $result->num_rows > 0) {
        $isValidCode = true;
        $referrerName = $result->fetch_assoc()['name'];
    }

    $conn->close();
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="theme-color" content="#667eea">
    <title>Join Gravity - Get Bonus Searches!</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        .invite-container {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px;
        }

        .invite-card {
            background: white;
            border-radius: 24px;
            padding: 40px 30px;
            max-width: 400px;
            width: 100%;
            text-align: center;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
        }

        .invite-icon {
            font-size: 64px;
            margin-bottom: 20px;
        }

        .invite-title {
            font-size: 28px;
            font-weight: 800;
            color: #1a1a1a;
            margin-bottom: 12px;
        }

        .invite-subtitle {
            font-size: 16px;
            color: #666;
            margin-bottom: 24px;
            line-height: 1.6;
        }

        .referrer-info {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px;
            border-radius: 16px;
            margin-bottom: 24px;
            color: white;
        }

        .referrer-name {
            font-size: 18px;
            font-weight: 700;
            margin-bottom: 8px;
        }

        .referrer-code {
            font-size: 24px;
            font-weight: 900;
            letter-spacing: 3px;
            background: rgba(255, 255, 255, 0.2);
            padding: 12px;
            border-radius: 8px;
            margin-top: 12px;
        }

        .bonus-badge {
            background: #34C759;
            color: white;
            padding: 12px 24px;
            border-radius: 12px;
            font-weight: 700;
            font-size: 18px;
            margin-bottom: 24px;
            display: inline-block;
        }

        .features-list {
            text-align: left;
            margin-bottom: 30px;
        }

        .feature-item {
            display: flex;
            align-items: center;
            gap: 12px;
            margin-bottom: 12px;
            font-size: 14px;
            color: #333;
        }

        .feature-icon {
            font-size: 24px;
        }

        .cta-button {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 16px 32px;
            border-radius: 12px;
            font-size: 18px;
            font-weight: 700;
            cursor: pointer;
            width: 100%;
            transition: transform 0.2s;
        }

        .cta-button:hover {
            transform: scale(1.05);
        }

        .login-link {
            margin-top: 16px;
            font-size: 14px;
            color: #666;
        }

        .login-link a {
            color: #667eea;
            font-weight: 700;
            text-decoration: none;
        }
    </style>
</head>

<body>
    <div class="invite-container">
        <div class="invite-card">
            <div class="invite-icon">🎁</div>

            <?php if ($isValidCode): ?>
                <h1 class="invite-title">You're Invited!</h1>
                <p class="invite-subtitle">
                    <?php echo htmlspecialchars($referrerName); ?> invited you to join Gravity
                </p>

                <div class="referrer-info">
                    <div class="referrer-name">Referral Code</div>
                    <div class="referrer-code"><?php echo htmlspecialchars($referralCode); ?></div>
                </div>

                <div class="bonus-badge">
                    🎉 Get +10 Bonus Searches!
                </div>
            <?php else: ?>
                <h1 class="invite-title">Join Gravity</h1>
                <p class="invite-subtitle">
                    Fast & Secure Mobile Number Search Platform
                </p>
            <?php endif; ?>

            <div class="features-list">
                <div class="feature-item">
                    <span class="feature-icon">⚡</span>
                    <span>Instant mobile number lookup</span>
                </div>
                <div class="feature-item">
                    <span class="feature-icon">🔒</span>
                    <span>100% secure & private</span>
                </div>
                <div class="feature-item">
                    <span class="feature-icon">📱</span>
                    <span>Mobile-friendly interface</span>
                </div>
                <?php if ($isValidCode): ?>
                    <div class="feature-item">
                        <span class="feature-icon">🎁</span>
                        <span>Bonus searches on signup</span>
                    </div>
                <?php endif; ?>
            </div>

            <button class="cta-button" onclick="proceedToRegister()">
                Get Started - It's Free!
            </button>

            <div class="login-link">
                Already have an account? <a href="login.php">Sign In</a>
            </div>
        </div>
    </div>

    <script>
        // Save referral code to localStorage
        <?php if ($isValidCode): ?>
            localStorage.setItem('referralCode', '<?php echo $referralCode; ?>');
            localStorage.setItem('referralExpiry', Date.now() + (7 * 24 * 60 * 60 * 1000)); // 7 days
        <?php endif; ?>

        function proceedToRegister() {
            window.location.href = 'register.php';
        }
    </script>
</body>

</html>