<?php
/**
 * Process Batch API - Process uploaded contacts
 */

ob_start();
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../config/api.php';
ob_end_clean();

requireUser();

header('Content-Type: application/json');

$userId = (int) $_SESSION['user_id'];
$input = json_decode(file_get_contents('php://input'), true);
$batchSize = isset($input['batch_size']) ? (int) $input['batch_size'] : 5;

$conn = getDBConnection();
$tempTable = "temp_upload_" . $userId;

// Check if temp table exists
$checkTable = $conn->query("SHOW TABLES LIKE '$tempTable'");
if (!$checkTable || $checkTable->num_rows === 0) {
    echo json_encode([
        'success' => false,
        'message' => 'No upload found. Please upload a file first.'
    ]);
    $conn->close();
    exit;
}

// Get unprocessed contacts
$sql = "SELECT * FROM $tempTable WHERE processed = 0 LIMIT $batchSize";
$result = $conn->query($sql);

if (!$result || $result->num_rows === 0) {
    // All done, cleanup
    $conn->query("DROP TABLE IF EXISTS $tempTable");
    echo json_encode([
        'success' => true,
        'processed' => 0,
        'success_count' => 0,
        'failed_count' => 0,
        'remaining' => 0,
        'message' => 'All contacts processed'
    ]);
    $conn->close();
    exit;
}

$processed = 0;
$success = 0;
$failed = 0;

while ($contact = $result->fetch_assoc()) {
    $phone = $contact['phone'];
    $contactId = $contact['id'];

    // Check if already searched
    $checkSql = "SELECT id FROM search_logs WHERE user_id = $userId AND mobile_number = '$phone'";
    $checkResult = $conn->query($checkSql);

    if ($checkResult && $checkResult->num_rows > 0) {
        // Already exists, mark as processed
        $conn->query("UPDATE $tempTable SET processed = 1 WHERE id = $contactId");
        $processed++;
        $success++;
        continue;
    }

    // Fetch from API
    $apiData = fetchFromAPI($phone);

    if ($apiData) {
        // Store in search_logs
        $dataJson = is_array($apiData) ? json_encode($apiData) : $apiData;
        $dataJson = $conn->real_escape_string($dataJson);

        $insertSql = "INSERT INTO search_logs (user_id, mobile_number, data, source, search_date) 
                      VALUES ($userId, '$phone', '$dataJson', 'API', NOW())";

        if ($conn->query($insertSql)) {
            $success++;
        } else {
            $failed++;
        }
    } else {
        $failed++;
    }

    // Mark as processed
    $conn->query("UPDATE $tempTable SET processed = 1 WHERE id = $contactId");
    $processed++;

    // Small delay
    usleep(500000); // 0.5 second
}

// Get remaining count
$remainingSql = "SELECT COUNT(*) as count FROM $tempTable WHERE processed = 0";
$remainingResult = $conn->query($remainingSql);
$remaining = $remainingResult ? $remainingResult->fetch_assoc()['count'] : 0;

$conn->close();

echo json_encode([
    'success' => true,
    'processed' => $processed,
    'success_count' => $success,
    'failed_count' => $failed,
    'remaining' => $remaining,
    'message' => "Processed $processed contacts"
]);
