<?php
require_once __DIR__ . '/../../includes/auth.php';

header('Content-Type: application/json');
requireAdmin();

$conn = getDBConnection();

$data = json_decode(file_get_contents('php://input'), true);
$userId = (int) ($data['userId'] ?? 0);
$searchType = $data['searchType'] ?? '';
$enabled = (int) ($data['enabled'] ?? 0);

if (!$userId || !in_array($searchType, ['mobile', 'ration'])) {
    echo json_encode(['success' => false, 'message' => 'Invalid parameters']);
    exit;
}

$column = $searchType === 'mobile' ? 'can_search_mobile' : 'can_search_ration';

$sql = "UPDATE users SET $column = ? WHERE id = ? AND role = 'user'";
$stmt = $conn->prepare($sql);
$stmt->bind_param('ii', $enabled, $userId);

if ($stmt->execute()) {
    echo json_encode(['success' => true, 'message' => 'Search permission updated']);
} else {
    echo json_encode(['success' => false, 'message' => 'Update failed']);
}

$stmt->close();
$conn->close();
