<?php
require_once __DIR__ . '/../../includes/auth.php';

requireAdmin();

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);

$userId = (int) ($input['userId'] ?? 0);
$permission = $input['permission'] ?? '';
$enabled = (int) ($input['enabled'] ?? 0);

$validPermissions = ['dashboard', 'search', 'history', 'profile', 'support'];

if (!$userId || !in_array($permission, $validPermissions)) {
    echo json_encode(['success' => false, 'message' => 'Invalid parameters']);
    exit;
}

$conn = getDBConnection();

// Check if permissions record exists
$checkSql = "SELECT id FROM user_nav_permissions WHERE user_id = $userId";
$result = $conn->query($checkSql);

if ($result->num_rows > 0) {
    // Update existing
    $sql = "UPDATE user_nav_permissions SET $permission = $enabled WHERE user_id = $userId";
} else {
    // Create new with default values
    $sql = "INSERT INTO user_nav_permissions (user_id, dashboard, search, history, profile, support) 
            VALUES ($userId, 1, 1, 1, 1, 1)";
    $conn->query($sql);

    // Now update the specific permission
    $sql = "UPDATE user_nav_permissions SET $permission = $enabled WHERE user_id = $userId";
}

if ($conn->query($sql)) {
    echo json_encode(['success' => true, 'message' => 'Permission updated']);
} else {
    echo json_encode(['success' => false, 'message' => 'Update failed']);
}

$conn->close();
