<?php
require_once __DIR__ . '/../../includes/auth.php';

header('Content-Type: application/json');
requireAdmin();

$id = (int) ($_GET['id'] ?? 0);

if (!$id) {
    echo json_encode(['success' => false, 'message' => 'Invalid ID']);
    exit;
}

$conn = getDBConnection();
$sql = "SELECT * FROM ration_card_data WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param('i', $id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $data = $result->fetch_assoc();
    echo json_encode(['success' => true, 'data' => $data]);
} else {
    echo json_encode(['success' => false, 'message' => 'Data not found']);
}

$stmt->close();
$conn->close();
