<?php
require_once __DIR__ . '/../../includes/auth.php';

requireAdmin();

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
$userId = (int) ($input['userId'] ?? 0);

if (!$userId) {
    echo json_encode(['success' => false, 'message' => 'Invalid user ID']);
    exit;
}

$conn = getDBConnection();

// First, delete related referral records
$deleteSql1 = "DELETE FROM referrals WHERE referrer_id = $userId OR referee_id = $userId";
$conn->query($deleteSql1);

// Then delete user (other cascades will handle remaining records)
$sql = "DELETE FROM users WHERE id = $userId AND role = 'user'";

if ($conn->query($sql)) {
    $affected = $conn->affected_rows;

    if ($affected > 0) {
        echo json_encode(['success' => true, 'message' => 'User deleted successfully']);
    } else {
        echo json_encode(['success' => false, 'message' => 'User not found or is admin']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Delete failed: ' . $conn->error]);
}

$conn->close();
