<?php
require_once __DIR__ . '/../includes/auth.php';

requireAdmin();

$conn = getDBConnection();

// Get all users with today's search count
$today = date('Y-m-d');
$sql = "SELECT u.*, 
        (SELECT COUNT(*) FROM search_logs WHERE user_id = u.id AND DATE(search_date) = '$today') as today_searches
        FROM users u 
        WHERE u.role = 'user' 
        ORDER BY u.created_at DESC";
$result = $conn->query($sql);
$users = [];
while ($row = $result->fetch_assoc()) {
    $users[] = $row;
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Management - Admin</title>
    <link rel="stylesheet" href="/app/assets/css/style.css">
    <link rel="stylesheet" href="/app/assets/css/admin.css">
</head>

<body>
    <div class="admin-container">
        <?php include __DIR__ . '/../includes/admin-nav.php'; ?>

        <div class="admin-content">
            <div class="admin-header">
                <h1 class="admin-title">User Management</h1>
                <a href="/app/api/logout.php" class="btn-logout-small">Logout</a>
            </div>

            <!-- Search Bar -->
            <div style="margin-bottom: 20px;">
                <input type="text" id="searchInput" placeholder="🔍 Search by name, email, or mobile..."
                    style="width: 100%; padding: 12px 16px; border: 2px solid var(--border-color); border-radius: 12px; font-size: 15px; background: var(--bg-primary); color: var(--text-primary);"
                    onkeyup="searchTable()">
            </div>

            <div class="card">
                <div class="table-responsive">
                    <table class="admin-table">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Mobile</th>
                                <th>Status</th>
                                <th>Daily Limit</th>
                                <th>Today's Searches</th>
                                <th>Created</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($users as $user): ?>
                                <tr>
                                    <td><?php echo $user['id']; ?></td>
                                    <td><?php echo htmlspecialchars($user['name']); ?></td>
                                    <td><?php echo htmlspecialchars($user['email']); ?></td>
                                    <td><?php echo htmlspecialchars($user['mobile']); ?></td>
                                    <td>
                                        <span
                                            class="badge badge-<?php echo $user['status'] === 'active' ? 'db' : 'api'; ?>">
                                            <?php echo ucfirst($user['status']); ?>
                                        </span>
                                    </td>
                                    <td><?php echo $user['daily_limit']; ?></td>
                                    <td>
                                        <span
                                            style="font-weight: 600; color: <?php echo $user['today_searches'] >= $user['daily_limit'] ? '#FF3B30' : '#34C759'; ?>;">
                                            <?php echo $user['today_searches']; ?> / <?php echo $user['daily_limit']; ?>
                                        </span>
                                    </td>
                                    <td><?php echo date('M d, Y', strtotime($user['created_at'])); ?></td>
                                    <td>
                                        <button class="btn-action btn-edit"
                                            onclick="editUser(<?php echo $user['id']; ?>)">Edit</button>
                                        <button class="btn-action btn-toggle"
                                            onclick="toggleStatus(<?php echo $user['id']; ?>, '<?php echo $user['status']; ?>')">
                                            <?php echo $user['status'] === 'active' ? 'Block' : 'Activate'; ?>
                                        </button>
                                        <button class="btn-action btn-delete"
                                            onclick="deleteUser(<?php echo $user['id']; ?>)">Delete</button>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Edit User Modal -->
    <div id="editModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title">Edit User</h3>
                <button class="modal-close" onclick="closeModal()">&times;</button>
            </div>
            <form id="editForm" class="form-admin">
                <input type="hidden" id="editUserId">
                <div class="form-group">
                    <label for="editName">Name</label>
                    <input type="text" id="editName" required>
                </div>
                <div class="form-group">
                    <label for="editEmail">Email</label>
                    <input type="email" id="editEmail" required>
                </div>
                <div class="form-group">
                    <label for="editMobile">Mobile</label>
                    <input type="tel" id="editMobile" required>
                </div>
                <div class="form-group">
                    <label for="editDailyLimit">Daily Search Limit</label>
                    <input type="number" id="editDailyLimit" min="1" required>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn-secondary" onclick="closeModal()">Cancel</button>
                    <button type="submit" class="btn-primary">Save Changes</button>
                </div>
            </form>
        </div>
    </div>

    <div id="toast" class="toast"></div>

    <script>
        function searchTable() {
            const input = document.getElementById('searchInput');
            const filter = input.value.toLowerCase();
            const table = document.querySelector('.admin-table tbody');
            const rows = table.getElementsByTagName('tr');

            for (let i = 0; i < rows.length; i++) {
                const cells = rows[i].getElementsByTagName('td');
                let found = false;

                // Search in name (index 1), email (index 2), mobile (index 3)
                for (let j = 1; j <= 3; j++) {
                    if (cells[j]) {
                        const text = cells[j].textContent || cells[j].innerText;
                        if (text.toLowerCase().indexOf(filter) > -1) {
                            found = true;
                            break;
                        }
                    }
                }

                rows[i].style.display = found ? '' : 'none';
            }
        }
    </script>
    <script src="/app/assets/js/admin-users.js"></script>
    <script src="/app/assets/js/admin-menu.js"></script>
</body>

</html>