<?php
require_once __DIR__ . '/../includes/auth.php';

requireAdmin();

$conn = getDBConnection();

// Get current settings
$sql = "SELECT * FROM settings";
$result = $conn->query($sql);
$settings = [];
while ($row = $result->fetch_assoc()) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Settings - Admin</title>
    <link rel="stylesheet" href="/app/assets/css/style.css">
    <link rel="stylesheet" href="/app/assets/css/admin.css">
    <style>
        /* Ensure toggle works properly */
        input:checked+.toggle-slider {
            background-color: #34C759 !important;
        }
    </style>
</head>

<body>
    <div class="admin-container">
        <?php include __DIR__ . '/../includes/admin-nav.php'; ?>

        <div class="admin-content">
            <div class="admin-header">
                <h1 class="admin-title">Application Settings</h1>
                <a href="/app/api/logout.php" class="btn-logout-small">Logout</a>
            </div>

            <div class="card">
                <h3 class="card-title" style="margin-bottom: 20px;">General Settings</h3>

                <form id="settingsForm" class="form-admin">
                    <div class="form-group">
                        <label for="appName">Application Name</label>
                        <input type="text" id="appName"
                            value="<?php echo htmlspecialchars($settings['app_name'] ?? 'Mobile Search Pro'); ?>"
                            required>
                    </div>

                    <div class="form-group">
                        <label for="appVersion">App Version</label>
                        <input type="text" id="appVersion"
                            value="<?php echo htmlspecialchars($settings['app_version'] ?? '1.0.0'); ?>"
                            placeholder="e.g., 1.0.0" required>
                    </div>

                    <div class="form-group">
                        <label for="buildingId">Building ID</label>
                        <input type="text" id="buildingId"
                            value="<?php echo htmlspecialchars($settings['building_id'] ?? '20251220'); ?>"
                            placeholder="e.g., 20251220" required>
                    </div>

                    <div class="form-group">
                        <label for="privacyPolicy">Privacy Policy Text</label>
                        <textarea id="privacyPolicy" rows="6" placeholder="Enter your privacy policy text here..."
                            style="resize: vertical; font-family: inherit; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px; background: var(--bg-secondary); color: var(--text-primary);"><?php echo htmlspecialchars($settings['privacy_policy_text'] ?? ''); ?></textarea>
                        <small style="color: var(--text-tertiary); margin-top: 4px; display: block;">
                            This will be shown to users in a popup
                        </small>
                    </div>

                    <div class="form-group">
                        <label for="termsOfService">Terms of Service Text</label>
                        <textarea id="termsOfService" rows="6" placeholder="Enter your terms of service text here..."
                            style="resize: vertical; font-family: inherit; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px; background: var(--bg-secondary); color: var(--text-primary);"><?php echo htmlspecialchars($settings['terms_of_service_text'] ?? ''); ?></textarea>
                        <small style="color: var(--text-tertiary); margin-top: 4px; display: block;">
                            This will be shown to users in a popup
                        </small>
                    </div>

                    <div class="form-group">
                        <label for="defaultDailyLimit">Default Daily Search Limit</label>
                        <input type="number" id="defaultDailyLimit"
                            value="<?php echo $settings['default_daily_limit'] ?? 10; ?>" min="1" required>
                        <small style="color: var(--text-tertiary); margin-top: 4px; display: block;">
                            This limit will be applied to new users
                        </small>
                    </div>

                    <div class="form-group">
                        <label style="display: flex; align-items: center; gap: 12px; cursor: pointer;">
                            <label class="toggle-switch">
                                <input type="checkbox" id="searchEnabled" <?php echo ($settings['search_enabled'] ?? 1) ? 'checked' : ''; ?>>
                                <span class="toggle-slider"></span>
                            </label>
                            <span>Enable Search System</span>
                        </label>
                        <small style="color: var(--text-tertiary); margin-top: 4px; display: block;">
                            When disabled, users cannot perform searches
                        </small>
                    </div>

                    <div class="form-group">
                        <label style="display: flex; align-items: center; gap: 12px; cursor: pointer;">
                            <label class="toggle-switch">
                                <input type="checkbox" id="maintenanceMode" <?php echo ($settings['maintenance_mode'] ?? 0) ? 'checked' : ''; ?>>
                                <span class="toggle-slider"></span>
                            </label>
                            <span>Maintenance Mode</span>
                        </label>
                        <small style="color: var(--text-tertiary); margin-top: 4px; display: block;">
                            When enabled, only admins can access the system
                        </small>
                    </div>

                    <!-- Referral System Settings -->
                    <h3 style="margin-top: 32px; margin-bottom: 16px; font-size: 18px; font-weight: 700;">🎁 Referral
                        System</h3>

                    <div class="form-group">
                        <label style="display: flex; align-items: center; gap: 12px; cursor: pointer;">
                            <label class="toggle-switch">
                                <input type="checkbox" id="referralEnabled" <?php echo (isset($settings['referral_enabled']) && $settings['referral_enabled'] == '1') ? 'checked' : ''; ?>>
                                <span class="toggle-slider"></span>
                            </label>
                            <span>Enable Referral System</span>
                        </label>
                        <small style="color: var(--text-tertiary); margin-top: 4px; display: block;">
                            Allow users to refer friends and earn bonus searches
                        </small>
                    </div>

                    <div class="form-group">
                        <label for="referrerReward">Referrer Reward (Searches)</label>
                        <input type="number" id="referrerReward" min="0" max="100"
                            value="<?php echo htmlspecialchars($settings['referrer_reward'] ?? '10'); ?>"
                            placeholder="e.g., 10">
                        <small style="color: var(--text-tertiary); margin-top: 4px; display: block;">
                            Bonus searches given to user who refers
                        </small>
                    </div>

                    <div class="form-group">
                        <label for="refereeReward">With Referral ID (Searches)</label>
                        <input type="number" id="refereeReward" min="0" max="100"
                            value="<?php echo htmlspecialchars($settings['referee_reward'] ?? '20'); ?>"
                            placeholder="e.g., 20">
                        <small style="color: var(--text-tertiary); margin-top: 4px; display: block;">
                            Total searches for new users who use referral ID
                        </small>
                    </div>

                    <div class="form-group">
                        <label for="defaultDailyLimit">Without Referral ID (Searches)</label>
                        <input type="number" id="defaultDailyLimit" min="1" max="1000"
                            value="<?php echo htmlspecialchars($settings['default_daily_limit'] ?? '10'); ?>"
                            placeholder="e.g., 10">
                        <small style="color: var(--text-tertiary); margin-top: 4px; display: block;">
                            Default searches for new users without referral ID
                        </small>
                    </div>

                    <button type="submit" class="btn-primary" style="margin-top: 20px;">
                        Save Settings
                    </button>
                </form>
            </div>
        </div>
    </div>

    <div id="toast" class="toast"></div>

    <script>
        document.getElementById('settingsForm').addEventListener('submit', async (e) => {
            e.preventDefault();

            const settings = {
                app_name: document.getElementById('appName').value,
                app_version: document.getElementById('appVersion').value,
                building_id: document.getElementById('buildingId').value,
                privacy_policy_text: document.getElementById('privacyPolicy').value,
                terms_of_service_text: document.getElementById('termsOfService').value,
                referral_enabled: document.getElementById('referralEnabled').checked ? 1 : 0,
                referrer_reward: document.getElementById('referrerReward').value,
                referee_reward: document.getElementById('refereeReward').value,
                default_daily_limit: document.getElementById('defaultDailyLimit').value,
                search_enabled: document.getElementById('searchEnabled').checked ? 1 : 0,
                maintenance_mode: document.getElementById('maintenanceMode').checked ? 1 : 0
            };

            try {
                const response = await fetch('/app/api/admin/update-settings.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify(settings)
                });

                const data = await response.json();

                if (data.success) {
                    showToast('Settings saved successfully', 'success');
                } else {
                    showToast(data.message || 'Save failed', 'error');
                }
            } catch (error) {
                showToast('Network error', 'error');
            }
        });

        function showToast(message, type = 'info') {
            const toast = document.getElementById('toast');
            toast.textContent = message;
            toast.className = `toast toast-${type} show`;
            setTimeout(() => toast.classList.remove('show'), 3000);
        }
    </script>
    <script src="/app/assets/js/admin-menu.js"></script>
</body>

</html>