<?php
require_once __DIR__ . '/../includes/auth.php';
requireAdmin();

$conn = getDBConnection();

echo "<h1>Database Debug - Search Logs</h1>";
echo "<style>body{font-family:monospace;padding:20px;} table{border-collapse:collapse;width:100%;} th,td{border:1px solid #ddd;padding:8px;text-align:left;} th{background:#007AFF;color:white;}</style>";

// Check search_logs table
echo "<h2>1. Search Logs Count</h2>";
$sql = "SELECT COUNT(*) as count FROM search_logs";
$result = $conn->query($sql);
if ($result) {
    $count = $result->fetch_assoc()['count'];
    echo "<p style='color:green;'>✅ Total searches: <strong>$count</strong></p>";
} else {
    echo "<p style='color:red;'>❌ Error: " . $conn->error . "</p>";
}

// Check recent searches
echo "<h2>2. Recent Searches (Last 10)</h2>";
$sql = "SELECT sl.*, u.name as user_name 
        FROM search_logs sl 
        JOIN users u ON sl.user_id = u.id 
        ORDER BY sl.search_date DESC 
        LIMIT 10";
$result = $conn->query($sql);

if ($result) {
    if ($result->num_rows > 0) {
        echo "<table>";
        echo "<tr><th>ID</th><th>User</th><th>Number/Aadhaar</th><th>Type</th><th>Source</th><th>Date</th></tr>";
        while ($row = $result->fetch_assoc()) {
            echo "<tr>";
            echo "<td>" . $row['id'] . "</td>";
            echo "<td>" . htmlspecialchars($row['user_name']) . "</td>";
            echo "<td>" . htmlspecialchars($row['mobile_number']) . "</td>";
            echo "<td>" . ($row['search_type'] ?? 'mobile') . "</td>";
            echo "<td>" . $row['source'] . "</td>";
            echo "<td>" . $row['search_date'] . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "<p style='color:orange;'>⚠️ No searches found in database</p>";
    }
} else {
    echo "<p style='color:red;'>❌ Query Error: " . $conn->error . "</p>";
}

// Check users table
echo "<h2>3. Users Count</h2>";
$sql = "SELECT COUNT(*) as count FROM users WHERE role = 'user'";
$result = $conn->query($sql);
if ($result) {
    $count = $result->fetch_assoc()['count'];
    echo "<p style='color:green;'>✅ Total users: <strong>$count</strong></p>";
} else {
    echo "<p style='color:red;'>❌ Error: " . $conn->error . "</p>";
}

// Check mobile_data table
echo "<h2>4. Mobile Data Count</h2>";
$sql = "SELECT COUNT(*) as count FROM mobile_data";
$result = $conn->query($sql);
if ($result) {
    $count = $result->fetch_assoc()['count'];
    echo "<p style='color:green;'>✅ Stored mobile numbers: <strong>$count</strong></p>";
} else {
    echo "<p style='color:red;'>❌ Error: " . $conn->error . "</p>";
}

// Check ration_card_data table
echo "<h2>5. Ration Card Data Count</h2>";
$sql = "SELECT COUNT(*) as count FROM ration_card_data";
$result = $conn->query($sql);
if ($result) {
    $count = $result->fetch_assoc()['count'];
    echo "<p style='color:green;'>✅ Stored ration cards: <strong>$count</strong></p>";
} else {
    echo "<p style='color:red;'>❌ Error: " . $conn->error . "</p>";
}

// Check table structure
echo "<h2>6. Search Logs Table Structure</h2>";
$sql = "DESCRIBE search_logs";
$result = $conn->query($sql);
if ($result) {
    echo "<table>";
    echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th></tr>";
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $row['Field'] . "</td>";
        echo "<td>" . $row['Type'] . "</td>";
        echo "<td>" . $row['Null'] . "</td>";
        echo "<td>" . $row['Key'] . "</td>";
        echo "<td>" . ($row['Default'] ?? 'NULL') . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p style='color:red;'>❌ Error: " . $conn->error . "</p>";
}

$conn->close();

echo "<br><br><a href='/app/admin/dashboard.php' style='padding:10px 20px;background:#007AFF;color:white;text-decoration:none;border-radius:8px;'>← Back to Dashboard</a>";
?>