<?php
require_once __DIR__ . '/../includes/auth.php';

requireAdmin();

$conn = getDBConnection();

// Get statistics
$stats = [];

// Total users
$sql = "SELECT COUNT(*) as count FROM users WHERE role = 'user'";
$result = $conn->query($sql);
$stats['total_users'] = $result->fetch_assoc()['count'];

// Active users
$sql = "SELECT COUNT(*) as count FROM users WHERE role = 'user' AND status = 'active'";
$result = $conn->query($sql);
$stats['active_users'] = $result->fetch_assoc()['count'];

// Total searches
$sql = "SELECT COUNT(*) as count FROM search_logs";
$result = $conn->query($sql);
$stats['total_searches'] = $result->fetch_assoc()['count'];

// Today's searches
$today = date('Y-m-d');
$sql = "SELECT COUNT(*) as count FROM search_logs WHERE DATE(search_date) = '$today'";
$result = $conn->query($sql);
$stats['today_searches'] = $result->fetch_assoc()['count'];

// Stored mobile numbers
$sql = "SELECT COUNT(*) as count FROM mobile_data";
$result = $conn->query($sql);
$stats['stored_numbers'] = $result->fetch_assoc()['count'];

// Stored ration cards
$sql = "SELECT COUNT(*) as count FROM ration_card_data";
$result = $conn->query($sql);
$stats['stored_ration_cards'] = $result->fetch_assoc()['count'];

// Mobile searches
$sql = "SELECT COUNT(*) as count FROM search_logs WHERE search_type = 'mobile'";
$result = $conn->query($sql);
$stats['mobile_searches'] = $result->fetch_assoc()['count'];

// Ration card searches
$sql = "SELECT COUNT(*) as count FROM search_logs WHERE search_type = 'ration_card'";
$result = $conn->query($sql);
$stats['ration_searches'] = $result->fetch_assoc()['count'];

// Today's API calls
$sql = "SELECT COUNT(*) as count FROM api_logs WHERE DATE(request_time) = '$today'";
$result = $conn->query($sql);
$stats['today_api_calls'] = $result->fetch_assoc()['count'];

// Recent searches
$sql = "SELECT sl.*, u.name as user_name 
        FROM search_logs sl 
        JOIN users u ON sl.user_id = u.id 
        ORDER BY sl.search_date DESC 
        LIMIT 10";
$recentResult = $conn->query($sql);
$recentSearches = [];
while ($row = $recentResult->fetch_assoc()) {
    $recentSearches[] = $row;
}

// Check API Health
$apiHealth = [
    'status' => 'unknown',
    'message' => 'Not tested',
    'response_time' => 0
];

// Better localhost detection (same as database.php)
$serverName = $_SERVER['SERVER_NAME'] ?? $_SERVER['HTTP_HOST'] ?? 'localhost';
$isLocalhost = in_array($serverName, ['localhost', '127.0.0.1', '::1']) ||
    preg_match('/^(10\.|192\.168\.|172\.(1[6-9]|2[0-9]|3[01])\.)/i', $serverName);

if ($isLocalhost) {
    // Localhost - skip API test (firewall issues)
    $apiHealth['status'] = 'local';
    $apiHealth['message'] = 'Localhost - API configured';
    $apiHealth['response_time'] = 0;
} else {
    // Live server - test API
    $startTime = microtime(true);
    $testUrl = 'https://aniketh.gauravyt566.workers.dev/?key=Gaur&mobile=9999999999';

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $testUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 5);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 3);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

    $response = @curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);

    $endTime = microtime(true);
    $apiHealth['response_time'] = round(($endTime - $startTime) * 1000); // ms

    if ($httpCode === 200 && !empty($response)) {
        $apiHealth['status'] = 'online';
        $apiHealth['message'] = 'API is working';
    } elseif ($error) {
        $apiHealth['status'] = 'offline';
        $apiHealth['message'] = 'Connection failed';
    } else {
        $apiHealth['status'] = 'error';
        $apiHealth['message'] = 'HTTP ' . $httpCode;
    }
}

// Check Database Performance
$dbHealth = [
    'status' => 'unknown',
    'response_time' => 0
];

$dbStart = microtime(true);
$testQuery = $conn->query("SELECT COUNT(*) as count FROM users");
$dbEnd = microtime(true);
$dbHealth['response_time'] = round(($dbEnd - $dbStart) * 1000, 2);

if ($testQuery) {
    if ($dbHealth['response_time'] < 50) {
        $dbHealth['status'] = 'excellent';
        $dbHealth['message'] = 'Excellent';
    } elseif ($dbHealth['response_time'] < 200) {
        $dbHealth['status'] = 'good';
        $dbHealth['message'] = 'Good';
    } else {
        $dbHealth['status'] = 'slow';
        $dbHealth['message'] = 'Slow';
    }
} else {
    $dbHealth['status'] = 'error';
    $dbHealth['message'] = 'Query failed';
}

// Server Info
$serverInfo = [
    'php_version' => phpversion(),
    'server_software' => $_SERVER['SERVER_SOFTWARE'] ?? 'Unknown',
    'max_execution_time' => ini_get('max_execution_time'),
    'memory_limit' => ini_get('memory_limit'),
    'upload_max_filesize' => ini_get('upload_max_filesize')
];

$conn->close();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="theme-color" content="#FFFFFF">
    <title>Admin Dashboard - Gravity</title>
    <link rel="stylesheet" href="/app/assets/css/style.css">
    <link rel="stylesheet" href="/app/assets/css/admin.css">
</head>

<body>
    <div class="admin-container">
        <?php include __DIR__ . '/../includes/admin-nav.php'; ?>

        <div class="admin-content">
            <div class="admin-header">
                <h1 class="admin-title">Dashboard</h1>
                <a href="/app/api/logout.php" class="btn-logout-small">Logout</a>
            </div>

            <div class="stats-grid-admin">
                <div class="stat-card-admin">
                    <div class="stat-icon-admin" style="background: rgba(0, 122, 255, 0.1);">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none">
                            <path
                                d="M16 11c1.66 0 2.99-1.34 2.99-3S17.66 5 16 5c-1.66 0-3 1.34-3 3s1.34 3 3 3zm-8 0c1.66 0 2.99-1.34 2.99-3S9.66 5 8 5C6.34 5 5 6.34 5 8s1.34 3 3 3zm0 2c-2.33 0-7 1.17-7 3.5V19h14v-2.5c0-2.33-4.67-3.5-7-3.5zm8 0c-.29 0-.62.02-.97.05 1.16.84 1.97 1.97 1.97 3.45V19h6v-2.5c0-2.33-4.67-3.5-7-3.5z"
                                fill="#007AFF" />
                        </svg>
                    </div>
                    <div class="stat-info-admin">
                        <p class="stat-label-admin">Total Users</p>
                        <p class="stat-value-admin"><?php echo $stats['total_users']; ?></p>
                    </div>
                </div>

                <div class="stat-card-admin">
                    <div class="stat-icon-admin" style="background: rgba(52, 199, 89, 0.1);">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none">
                            <path
                                d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"
                                fill="#34C759" />
                        </svg>
                    </div>
                    <div class="stat-info-admin">
                        <p class="stat-label-admin">Active Users</p>
                        <p class="stat-value-admin"><?php echo $stats['active_users']; ?></p>
                    </div>
                </div>

                <div class="stat-card-admin">
                    <div class="stat-icon-admin" style="background: rgba(255, 149, 0, 0.1);">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none">
                            <path
                                d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z"
                                fill="#FF9500" />
                        </svg>
                    </div>
                    <div class="stat-info-admin">
                        <p class="stat-label-admin">Total Searches</p>
                        <p class="stat-value-admin"><?php echo $stats['total_searches']; ?></p>
                    </div>
                </div>

                <div class="stat-card-admin">
                    <div class="stat-icon-admin" style="background: rgba(88, 86, 214, 0.1);">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none">
                            <path
                                d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zM9 17H7v-7h2v7zm4 0h-2V7h2v10zm4 0h-2v-4h2v4z"
                                fill="#5856D6" />
                        </svg>
                    </div>
                    <div class="stat-info-admin">
                        <p class="stat-label-admin">Today's Searches</p>
                        <p class="stat-value-admin"><?php echo $stats['today_searches']; ?></p>
                    </div>
                </div>

                <div class="stat-card-admin">
                    <div class="stat-icon-admin" style="background: rgba(255, 59, 48, 0.1);">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none">
                            <path
                                d="M20 2H4c-1.1 0-1.99.9-1.99 2L2 22l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zM6 9h12v2H6V9zm8 5H6v-2h8v2zm4-6H6V6h12v2z"
                                fill="#FF3B30" />
                        </svg>
                    </div>
                    <div class="stat-info-admin">
                        <p class="stat-label-admin">Stored Numbers</p>
                        <p class="stat-value-admin"><?php echo $stats['stored_numbers']; ?></p>
                    </div>
                </div>

                <div class="stat-card-admin">
                    <div class="stat-icon-admin" style="background: rgba(118, 75, 162, 0.1);">
                        <span style="font-size: 24px;">🎫</span>
                    </div>
                    <div class="stat-info-admin">
                        <p class="stat-label-admin">Stored Ration Cards</p>
                        <p class="stat-value-admin"><?php echo $stats['stored_ration_cards']; ?></p>
                    </div>
                </div>

                <div class="stat-card-admin">
                    <div class="stat-icon-admin" style="background: rgba(0, 122, 255, 0.1);">
                        <span style="font-size: 24px;">📱</span>
                    </div>
                    <div class="stat-info-admin">
                        <p class="stat-label-admin">Mobile Searches</p>
                        <p class="stat-value-admin"><?php echo $stats['mobile_searches']; ?></p>
                    </div>
                </div>

                <div class="stat-card-admin">
                    <div class="stat-icon-admin" style="background: rgba(118, 75, 162, 0.1);">
                        <span style="font-size: 24px;">🎫</span>
                    </div>
                    <div class="stat-info-admin">
                        <p class="stat-label-admin">Ration Card Searches</p>
                        <p class="stat-value-admin"><?php echo $stats['ration_searches']; ?></p>
                    </div>
                </div>

                <div class="stat-card-admin">
                    <div class="stat-icon-admin" style="background: rgba(175, 82, 222, 0.1);">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none">
                            <path
                                d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"
                                fill="#AF52DE" />
                        </svg>
                    </div>
                    <div class="stat-info-admin">
                        <p class="stat-label-admin">Today's API Calls</p>
                        <p class="stat-value-admin"><?php echo $stats['today_api_calls']; ?></p>
                    </div>
                </div>
            </div>

            <!-- System Health Card -->
            <div class="card" style="margin-bottom: 24px;">
                <div class="card-header">
                    <h3 class="card-title">⚡ System Health</h3>
                </div>
                <div class="card-body">
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 16px;">
                        <!-- API Status -->
                        <div style="padding: 16px; background: <?php
                        echo $apiHealth['status'] === 'online' ? 'rgba(52, 199, 89, 0.1)' :
                            ($apiHealth['status'] === 'offline' ? 'rgba(255, 59, 48, 0.1)' :
                                ($apiHealth['status'] === 'local' ? 'rgba(0, 122, 255, 0.1)' : 'rgba(255, 149, 0, 0.1)'));
                        ?>; border-radius: 12px;">
                            <div style="display: flex; align-items: center; gap: 8px; margin-bottom: 8px;">
                                <div style="width: 10px; height: 10px; border-radius: 50%; background: <?php
                                echo $apiHealth['status'] === 'online' ? '#34C759' :
                                    ($apiHealth['status'] === 'offline' ? '#FF3B30' :
                                        ($apiHealth['status'] === 'local' ? '#007AFF' : '#FF9500'));
                                ?>"></div>
                                <strong style="font-size: 14px;">API Status</strong>
                            </div>
                            <p style="font-size: 13px; color: #8E8E93; margin: 0;"><?php echo $apiHealth['message']; ?>
                            </p>
                            <?php if ($apiHealth['status'] === 'online'): ?>
                                <p style="font-size: 12px; color: #8E8E93; margin: 4px 0 0 0;">Response:
                                    <?php echo $apiHealth['response_time']; ?>ms
                                </p>
                            <?php endif; ?>
                        </div>

                        <!-- Database Performance -->
                        <div style="padding: 16px; background: <?php
                        echo $dbHealth['status'] === 'excellent' ? 'rgba(52, 199, 89, 0.1)' :
                            ($dbHealth['status'] === 'good' ? 'rgba(0, 122, 255, 0.1)' :
                                ($dbHealth['status'] === 'slow' ? 'rgba(255, 149, 0, 0.1)' : 'rgba(255, 59, 48, 0.1)'));
                        ?>; border-radius: 12px;">
                            <div style="display: flex; align-items: center; gap: 8px; margin-bottom: 8px;">
                                <div style="width: 10px; height: 10px; border-radius: 50%; background: <?php
                                echo $dbHealth['status'] === 'excellent' ? '#34C759' :
                                    ($dbHealth['status'] === 'good' ? '#007AFF' :
                                        ($dbHealth['status'] === 'slow' ? '#FF9500' : '#FF3B30'));
                                ?>"></div>
                                <strong style="font-size: 14px;">Database</strong>
                            </div>
                            <p style="font-size: 13px; color: #8E8E93; margin: 0;"><?php echo $dbHealth['message']; ?>
                            </p>
                            <p style="font-size: 12px; color: #8E8E93; margin: 4px 0 0 0;">
                                Query: <?php echo $dbHealth['response_time']; ?>ms
                            </p>
                        </div>

                        <!-- Server Status -->
                        <div style="padding: 16px; background: rgba(142, 142, 147, 0.1); border-radius: 12px;">
                            <div style="display: flex; align-items: center; gap: 8px; margin-bottom: 8px;">
                                <div style="width: 10px; height: 10px; border-radius: 50%; background: #34C759;"></div>
                                <strong style="font-size: 14px;">Server</strong>
                            </div>
                            <p style="font-size: 13px; color: #8E8E93; margin: 0;">PHP
                                <?php echo $serverInfo['php_version']; ?>
                            </p>
                            <p style="font-size: 12px; color: #8E8E93; margin: 4px 0 0 0;">
                                Memory: <?php echo $serverInfo['memory_limit']; ?>
                            </p>
                        </div>
                    </div>

                    <!-- Performance Details -->
                    <div
                        style="margin-top: 16px; padding: 16px; background: rgba(142, 142, 147, 0.05); border-radius: 12px;">
                        <div
                            style="display: grid; grid-template-columns: repeat(auto-fit, minmax(150px, 1fr)); gap: 12px; font-size: 13px;">
                            <div>
                                <span style="color: #8E8E93;">Max Execution:</span>
                                <strong
                                    style="margin-left: 8px;"><?php echo $serverInfo['max_execution_time']; ?>s</strong>
                            </div>
                            <div>
                                <span style="color: #8E8E93;">Upload Limit:</span>
                                <strong
                                    style="margin-left: 8px;"><?php echo $serverInfo['upload_max_filesize']; ?></strong>
                            </div>
                            <div>
                                <span style="color: #8E8E93;">Environment:</span>
                                <strong
                                    style="margin-left: 8px;"><?php echo $isLocalhost ? 'Localhost' : 'Live'; ?></strong>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Recent Searches</h3>
                </div>
                <div class="table-responsive">
                    <table class="admin-table">
                        <thead>
                            <tr>
                                <th>Type</th>
                                <th>User</th>
                                <th>Number/Aadhaar</th>
                                <th>Source</th>
                                <th>Date & Time</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($recentSearches as $search):
                                $searchType = $search['search_type'] ?? 'mobile';
                                $icon = $searchType === 'ration_card' ? '🎫' : '📱';
                                $typeLabel = $searchType === 'ration_card' ? 'Ration Card' : 'Mobile';
                                $typeColor = $searchType === 'ration_card' ? '#764ba2' : '#007AFF';
                                ?>
                                    <tr>
                                        <td>
                                            <span
                                                style="font-size: 20px; display: inline-block; margin-right: 4px;"><?php echo $icon; ?></span>
                                            <span style="color: <?php echo $typeColor; ?>; font-weight: 600; font-size: 12px;">
                                                <?php echo $typeLabel; ?>
                                            </span>
                                        </td>
                                        <td><?php echo htmlspecialchars($search['user_name']); ?></td>
                                        <td><?php echo htmlspecialchars($search['mobile_number']); ?></td>
                                        <td>
                                            <span class="badge badge-<?php echo strtolower($search['source']); ?>">
                                                <?php echo $search['source']; ?>
                                            </span>
                                        </td>
                                        <td><?php echo date('M d, Y h:i A', strtotime($search['search_date'])); ?></td>
                                    </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <script src="/app/assets/js/admin-menu.js"></script>
</body>

</html>