<?php
require_once __DIR__ . '/../includes/auth.php';
requireAdmin();

header('Content-Type: application/json');

$aadhaar = $_GET['aadhaar'] ?? '';

if (empty($aadhaar)) {
    echo json_encode(['found' => false, 'error' => 'No aadhaar provided']);
    exit;
}

$conn = getDBConnection();

// Check if this aadhaar exists in api_logs
$sql = "SELECT * FROM api_logs WHERE mobile_number = ? ORDER BY request_time DESC LIMIT 1";
$stmt = $conn->prepare($sql);
$stmt->bind_param('s', $aadhaar);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $log = $result->fetch_assoc();
    echo json_encode([
        'found' => true,
        'log' => $log
    ]);
} else {
    echo json_encode([
        'found' => false,
        'message' => 'Not found in API logs'
    ]);
}

$conn->close();
?>